/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.resources;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.resources.AbstractBaseResource;
import org.apache.syncope.common.rest.api.beans.AnyListQuery;
import org.apache.syncope.common.rest.api.service.GroupService;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncopeGroupResource
extends AbstractBaseResource {
    private static final long serialVersionUID = 7475706378304995200L;
    private static final Logger LOG = LoggerFactory.getLogger(SyncopeGroupResource.class);
    private final GroupService groupService = SyncopeEnduserSession.get().getService(GroupService.class);

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        LOG.debug("Search all available groups");
        AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
        try {
            HttpServletRequest request = (HttpServletRequest)attributes.getRequest().getContainerRequest();
            if (!this.xsrfCheck(request)) {
                LOG.error("XSRF TOKEN does not match");
                response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "XSRF TOKEN does not match");
                return response;
            }
            String realm = URLDecoder.decode(attributes.getParameters().get("realm").toString("/"), "UTF-8");
            final List groupTOs = this.groupService.list((AnyListQuery)new AnyListQuery.Builder().realm(realm).build()).getResult();
            response.setWriteCallback(new AbstractResource.WriteCallback(){

                public void writeData(IResource.Attributes attributes) throws IOException {
                    attributes.getResponse().write((CharSequence)AbstractBaseResource.MAPPER.writeValueAsString((Object)groupTOs));
                }
            });
            response.setStatusCode(Integer.valueOf(Response.Status.OK.getStatusCode()));
        }
        catch (Exception e) {
            LOG.error("Error retrieving available grupss", (Throwable)e);
            response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "ErrorMessage{{ " + e.getMessage() + " }}");
        }
        return response;
    }
}

