/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.resources;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.resources.AbstractBaseResource;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.rest.api.service.UserSelfService;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;

public class UserSelfUpdateResource
extends AbstractBaseResource {
    private static final long serialVersionUID = -2721621682300247583L;

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
        try {
            HttpServletRequest request = (HttpServletRequest)attributes.getRequest().getContainerRequest();
            if (!this.xsrfCheck(request)) {
                LOG.error("XSRF TOKEN does not match");
                response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "XSRF TOKEN does not match");
                return response;
            }
            if (!this.captchaCheck(request.getHeader("captcha"), request.getSession().getAttribute("captcha"))) {
                throw new IllegalArgumentException("Entered captcha is not matching");
            }
            UserTO userTO = (UserTO)MAPPER.readValue(request.getReader().readLine(), UserTO.class);
            LOG.debug("User {} id self-updating", (Object)userTO.getUsername());
            Map userPlainAttrMap = userTO.getPlainAttrMap();
            for (PlainSchemaTO plainSchema : SyncopeEnduserSession.get().getDatePlainSchemas()) {
                if (!userPlainAttrMap.containsKey(plainSchema.getKey())) continue;
                FastDateFormat fmt = FastDateFormat.getInstance((String)plainSchema.getConversionPattern());
                AttrTO dateAttr = (AttrTO)userPlainAttrMap.get(plainSchema.getKey());
                ArrayList<String> formattedValues = new ArrayList<String>(dateAttr.getValues().size());
                for (String value : dateAttr.getValues()) {
                    try {
                        formattedValues.add(fmt.format((Object)Long.valueOf(value)));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Invalid format value for " + value);
                    }
                }
                dateAttr.getValues().clear();
                dateAttr.getValues().addAll(formattedValues);
            }
            Response res = SyncopeEnduserSession.get().getService(userTO.getETagValue(), UserSelfService.class).update(userTO);
            final String responseMessage = res.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL) ? "User" + userTO.getUsername() + " successfully updated" : "ErrorMessage{{ " + res.getStatusInfo().getReasonPhrase() + " }}";
            response.setWriteCallback(new AbstractResource.WriteCallback(){

                public void writeData(IResource.Attributes attributes) throws IOException {
                    attributes.getResponse().write((CharSequence)responseMessage);
                }
            });
            response.setStatusCode(Integer.valueOf(res.getStatus()));
        }
        catch (Exception e) {
            LOG.error("Error while updating user", (Throwable)e);
            response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "ErrorMessage{{ " + e.getMessage() + " }}");
        }
        return response;
    }
}

