/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.resources;

import com.fasterxml.jackson.databind.ObjectMapper;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.enduser.SyncopeEnduserApplication;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.wicket.request.resource.AbstractResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBaseResource
extends AbstractResource {
    private static final long serialVersionUID = -7875801358718612782L;
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractBaseResource.class);
    protected static final ObjectMapper MAPPER = new ObjectMapper();

    protected final boolean isSelfRegistrationAllowed() {
        Boolean result = null;
        try {
            result = SyncopeEnduserSession.get().getPlatformInfo().isSelfRegAllowed();
        }
        catch (SyncopeClientException e) {
            LOG.error("While seeking if self registration is allowed", (Throwable)e);
        }
        return result == null ? false : result;
    }

    protected final boolean xsrfCheck(HttpServletRequest request) {
        String requestXSRFHeader = request.getHeader("X-XSRF-TOKEN");
        return SyncopeEnduserApplication.get().isXsrfEnabled() ? StringUtils.isNotBlank((CharSequence)requestXSRFHeader) && SyncopeEnduserSession.get().getCookieUtils().getCookie("XSRF-TOKEN").getValue().equals(requestXSRFHeader) : true;
    }

    protected final boolean captchaCheck(String enteredCaptcha, Object currentCaptcha) {
        return SyncopeEnduserApplication.get().isCaptchaEnabled() ? (StringUtils.isBlank((CharSequence)currentCaptcha.toString()) || enteredCaptcha == null ? false : enteredCaptcha.equals(currentCaptcha.toString())) : true;
    }
}

