/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.resources;

import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.resources.AbstractBaseResource;
import org.apache.syncope.common.rest.api.service.UserSelfService;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserSelfConfirmPasswordReset
extends AbstractBaseResource {
    private static final long serialVersionUID = -2721621682300247583L;
    private static final Logger LOG = LoggerFactory.getLogger(UserSelfConfirmPasswordReset.class);
    private final UserSelfService userSelfService = SyncopeEnduserSession.get().getService(UserSelfService.class);

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
        try {
            HttpServletRequest request = (HttpServletRequest)attributes.getRequest().getContainerRequest();
            if (!this.xsrfCheck(request)) {
                LOG.error("XSRF TOKEN does not match");
                response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "XSRF TOKEN does not match");
                return response;
            }
            Map parameters = request.getParameterMap();
            if (parameters.get("token") == null || ((String[])parameters.get("token")).length == 0) {
                throw new Exception("A valid token should be provided");
            }
            String token = ((String[])parameters.get("token"))[0];
            if (parameters.get("newPassword") == null || ((String[])parameters.get("newPassword")).length == 0) {
                throw new Exception("A new correct password should be provided");
            }
            this.userSelfService.confirmPasswordReset(token, ((String[])parameters.get("newPassword"))[0]);
            final String responseMessage = "Password changed correctly";
            response.setWriteCallback(new AbstractResource.WriteCallback(){

                public void writeData(IResource.Attributes attributes) throws IOException {
                    attributes.getResponse().write((CharSequence)responseMessage);
                }
            });
            response.setStatusCode(Integer.valueOf(Response.Status.OK.getStatusCode()));
        }
        catch (Exception e) {
            LOG.error("Error while updating user", (Throwable)e);
            response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "ErrorMessage{{ " + e.getMessage() + " }}");
        }
        return response;
    }
}

