/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.resources;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.resources.AbstractBaseResource;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;

public class UserSelfReadResource
extends AbstractBaseResource {
    private static final long serialVersionUID = -9184809392631523912L;

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        LOG.debug("Requested user self information");
        AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
        try {
            HttpServletRequest request = (HttpServletRequest)attributes.getRequest().getContainerRequest();
            if (!this.xsrfCheck(request)) {
                LOG.error("XSRF TOKEN does not match");
                response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "XSRF TOKEN does not match");
                return response;
            }
            UserTO userTO = (UserTO)SerializationUtils.clone((Serializable)SyncopeEnduserSession.get().getSelfTO());
            Map userPlainAttrMap = userTO.getPlainAttrMap();
            for (PlainSchemaTO plainSchema : SyncopeEnduserSession.get().getDatePlainSchemas()) {
                if (!userPlainAttrMap.containsKey(plainSchema.getKey())) continue;
                FastDateFormat fmt = FastDateFormat.getInstance((String)plainSchema.getConversionPattern());
                AttrTO dateAttr = (AttrTO)userPlainAttrMap.get(plainSchema.getKey());
                ArrayList<String> milliValues = new ArrayList<String>(dateAttr.getValues().size());
                for (String value : dateAttr.getValues()) {
                    milliValues.add(String.valueOf(fmt.parse(value).getTime()));
                }
                dateAttr.getValues().clear();
                dateAttr.getValues().addAll(milliValues);
            }
            for (MembershipTO membership : userTO.getMemberships()) {
                String groupName = membership.getGroupName();
                for (AttrTO attr : membership.getPlainAttrs()) {
                    attr.setSchema(groupName.concat("#").concat(attr.getSchema()));
                    userTO.getPlainAttrs().add(attr);
                }
                membership.getPlainAttrs().clear();
                for (AttrTO attr : membership.getDerAttrs()) {
                    attr.setSchema(groupName.concat("#").concat(attr.getSchema()));
                    userTO.getDerAttrs().add(attr);
                }
                membership.getDerAttrs().clear();
                for (AttrTO attr : membership.getVirAttrs()) {
                    attr.setSchema(groupName.concat("#").concat(attr.getSchema()));
                    userTO.getVirAttrs().add(attr);
                }
                membership.getVirAttrs().clear();
            }
            final String selfTOJson = MAPPER.writeValueAsString((Object)userTO);
            response.setWriteCallback(new AbstractResource.WriteCallback(){

                public void writeData(IResource.Attributes attributes) throws IOException {
                    attributes.getResponse().write((CharSequence)selfTOJson);
                }
            });
            response.setStatusCode(Integer.valueOf(Response.Status.OK.getStatusCode()));
        }
        catch (Exception e) {
            LOG.error("Error retrieving selfTO user", (Throwable)e);
            response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "ErrorMessage{{ " + e.getMessage() + " }}");
        }
        return response;
    }
}

