/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.pages.HomePage;
import org.apache.syncope.client.enduser.resources.AnyTypeClassResource;
import org.apache.syncope.client.enduser.resources.AnyTypeResource;
import org.apache.syncope.client.enduser.resources.CaptchaResource;
import org.apache.syncope.client.enduser.resources.ExternalResourceResource;
import org.apache.syncope.client.enduser.resources.GroupResource;
import org.apache.syncope.client.enduser.resources.InfoResource;
import org.apache.syncope.client.enduser.resources.LoginResource;
import org.apache.syncope.client.enduser.resources.LogoutResource;
import org.apache.syncope.client.enduser.resources.RealmResource;
import org.apache.syncope.client.enduser.resources.SchemaResource;
import org.apache.syncope.client.enduser.resources.SecurityQuestionResource;
import org.apache.syncope.client.enduser.resources.UserSelfChangePassword;
import org.apache.syncope.client.enduser.resources.UserSelfConfirmPasswordReset;
import org.apache.syncope.client.enduser.resources.UserSelfCreateResource;
import org.apache.syncope.client.enduser.resources.UserSelfIsLogged;
import org.apache.syncope.client.enduser.resources.UserSelfPasswordReset;
import org.apache.syncope.client.enduser.resources.UserSelfReadResource;
import org.apache.syncope.client.enduser.resources.UserSelfUpdateResource;
import org.apache.syncope.client.lib.SyncopeClientFactoryBean;
import org.apache.wicket.Page;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Args;

public class SyncopeEnduserApplication
extends WebApplication
implements Serializable {
    private static final long serialVersionUID = -6445919351044845120L;
    private static final String ENDUSER_PROPERTIES = "enduser.properties";
    private String version;
    private String site;
    private String license;
    private String domain;
    private String adminUser;
    private String anonymousUser;
    private String anonymousKey;
    private boolean captchaEnabled;
    private boolean xsrfEnabled;
    private SyncopeClientFactoryBean clientFactory;

    public static SyncopeEnduserApplication get() {
        return (SyncopeEnduserApplication)WebApplication.get();
    }

    protected void init() {
        super.init();
        Properties props = new Properties();
        try {
            File enduserDirProps;
            props.load(this.getClass().getResourceAsStream("/enduser.properties"));
            File enduserDir = new File(props.getProperty("enduser.directory"));
            if (enduserDir.exists() && enduserDir.canRead() && enduserDir.isDirectory() && (enduserDirProps = FileUtils.getFile((File)enduserDir, (String[])new String[]{ENDUSER_PROPERTIES})).exists() && enduserDirProps.canRead() && enduserDirProps.isFile()) {
                props.clear();
                props.load(FileUtils.openInputStream((File)enduserDirProps));
            }
        }
        catch (Exception e) {
            throw new WicketRuntimeException("Could not read enduser.properties", (Throwable)e);
        }
        this.version = props.getProperty("version");
        Args.notNull((Object)this.version, (String)"<version> not set");
        this.site = props.getProperty("site");
        Args.notNull((Object)this.site, (String)"<site> not set");
        this.license = props.getProperty("license");
        Args.notNull((Object)this.license, (String)"<license> not set");
        this.domain = props.getProperty("domain", "Master");
        this.adminUser = props.getProperty("adminUser");
        Args.notNull((Object)this.adminUser, (String)"<adminUser> not set");
        this.anonymousUser = props.getProperty("anonymousUser");
        Args.notNull((Object)this.anonymousUser, (String)"<anonymousUser> not set");
        this.anonymousKey = props.getProperty("anonymousKey");
        Args.notNull((Object)this.anonymousKey, (String)"<anonymousKey> not set");
        this.captchaEnabled = Boolean.parseBoolean(props.getProperty("captcha"));
        Args.notNull((Object)this.captchaEnabled, (String)"<captcha> not set");
        this.xsrfEnabled = Boolean.parseBoolean(props.getProperty("xsrf"));
        Args.notNull((Object)this.xsrfEnabled, (String)"<xsrf> not set");
        String scheme = props.getProperty("scheme");
        Args.notNull((Object)scheme, (String)"<scheme> not set");
        String host = props.getProperty("host");
        Args.notNull((Object)host, (String)"<host> not set");
        String port = props.getProperty("port");
        Args.notNull((Object)port, (String)"<port> not set");
        String rootPath = props.getProperty("rootPath");
        Args.notNull((Object)rootPath, (String)"<rootPath> not set");
        String useGZIPCompression = props.getProperty("useGZIPCompression");
        Args.notNull((Object)rootPath, (String)"<useGZIPCompression> not set");
        this.clientFactory = new SyncopeClientFactoryBean().setAddress(scheme + "://" + host + ":" + port + "/" + rootPath).setContentType(SyncopeClientFactoryBean.ContentType.JSON).setUseCompression(BooleanUtils.toBoolean((String)useGZIPCompression));
        this.mountResource("/api/login", new ResourceReference("login"){
            private static final long serialVersionUID = -128426276529456602L;

            public IResource getResource() {
                return new LoginResource();
            }
        });
        this.mountResource("/api/logout", new ResourceReference("logout"){
            private static final long serialVersionUID = -128426276529456602L;

            public IResource getResource() {
                return new LogoutResource();
            }
        });
        this.mountResource("/api/self/islogged", new ResourceReference("userSelfIsLogged"){
            private static final long serialVersionUID = -128426276529456602L;

            public IResource getResource() {
                return new UserSelfIsLogged();
            }
        });
        this.mountResource("/api/self/read", new ResourceReference("userSelfRead"){
            private static final long serialVersionUID = -128426276529456602L;

            public IResource getResource() {
                return new UserSelfReadResource();
            }
        });
        this.mountResource("/api/self/create", new ResourceReference("userSelfCreate"){
            private static final long serialVersionUID = -128426276529456602L;

            public IResource getResource() {
                return new UserSelfCreateResource();
            }
        });
        this.mountResource("/api/self/update", new ResourceReference("userSelfUpdate"){
            private static final long serialVersionUID = -128426276529456602L;

            public IResource getResource() {
                return new UserSelfUpdateResource();
            }
        });
        this.mountResource("/api/self/requestPasswordReset", new ResourceReference("userSelfPasswordReset"){
            private static final long serialVersionUID = -128426276529456602L;

            public IResource getResource() {
                return new UserSelfPasswordReset();
            }
        });
        this.mountResource("/api/self/confirmPasswordReset", new ResourceReference("userSelfConfirmPasswordReset"){
            private static final long serialVersionUID = -128426276529456602L;

            public IResource getResource() {
                return new UserSelfConfirmPasswordReset();
            }
        });
        this.mountResource("/api/self/changePassword", new ResourceReference("userSelfChangePassword"){
            private static final long serialVersionUID = -128426276529456602L;

            public IResource getResource() {
                return new UserSelfChangePassword();
            }
        });
        this.mountResource("/api/schemas", new ResourceReference("schemas"){
            private static final long serialVersionUID = -128426276529456602L;

            public IResource getResource() {
                return new SchemaResource();
            }
        });
        this.mountResource("/api/resources", new ResourceReference("resources"){
            private static final long serialVersionUID = -128426276529456602L;

            public IResource getResource() {
                return new ExternalResourceResource();
            }
        });
        this.mountResource("/api/securityQuestions", new ResourceReference("securityQuestions"){
            private static final long serialVersionUID = -128426276529456602L;

            public IResource getResource() {
                return new SecurityQuestionResource();
            }
        });
        this.mountResource("/api/securityQuestions/byUser/${username}", new ResourceReference("securityQuestions"){
            private static final long serialVersionUID = -128426276529456602L;

            public IResource getResource() {
                return new SecurityQuestionResource();
            }
        });
        this.mountResource("/api/info", new ResourceReference("info"){
            private static final long serialVersionUID = -128426276529456602L;

            public IResource getResource() {
                return new InfoResource();
            }
        });
        this.mountResource("/api/captcha", new ResourceReference("captcha"){
            private static final long serialVersionUID = -128426276529456602L;

            public IResource getResource() {
                return new CaptchaResource();
            }
        });
        this.mountResource("/api/realms", new ResourceReference("realms"){
            private static final long serialVersionUID = -128426276529456602L;

            public IResource getResource() {
                return new RealmResource();
            }
        });
        this.mountResource("/api/groups", new ResourceReference("groups"){
            private static final long serialVersionUID = -128426276529456602L;

            public IResource getResource() {
                return new GroupResource();
            }
        });
        this.mountResource("/api/auxiliaryClasses", new ResourceReference("auxClasses"){
            private static final long serialVersionUID = -128426276529456602L;

            public IResource getResource() {
                return new AnyTypeClassResource();
            }
        });
        this.mountResource("/api/anyTypes", new ResourceReference("anyType"){
            private static final long serialVersionUID = -128426276529456602L;

            public IResource getResource() {
                return new AnyTypeResource();
            }
        });
    }

    public Class<? extends Page> getHomePage() {
        return HomePage.class;
    }

    public Session newSession(Request request, Response response) {
        return new SyncopeEnduserSession(request);
    }

    public String getVersion() {
        return this.version;
    }

    public String getSite() {
        return this.site;
    }

    public String getLicense() {
        return this.license;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getAdminUser() {
        return this.adminUser;
    }

    public String getAnonymousUser() {
        return this.anonymousUser;
    }

    public String getAnonymousKey() {
        return this.anonymousKey;
    }

    public SyncopeClientFactoryBean getClientFactory() {
        return this.clientFactory;
    }

    public boolean isCaptchaEnabled() {
        return this.captchaEnabled;
    }

    public boolean isXsrfEnabled() {
        return this.xsrfEnabled;
    }
}

