/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.resources;

import java.io.IOException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.adapters.PlatformInfoAdapter;
import org.apache.syncope.client.enduser.resources.AbstractBaseResource;
import org.apache.syncope.client.enduser.util.SaltGenerator;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.util.cookies.CookieUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoResource
extends AbstractBaseResource {
    private static final Logger LOG = LoggerFactory.getLogger(InfoResource.class);
    private static final long serialVersionUID = 6453101466981543020L;

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
        try {
            CookieUtils sessionCookieUtils = SyncopeEnduserSession.get().getCookieUtils();
            if (!SyncopeEnduserSession.get().isXsrfTokenGenerated() && (sessionCookieUtils.getCookie("XSRF-TOKEN") == null || StringUtils.isBlank((CharSequence)sessionCookieUtils.getCookie("XSRF-TOKEN").getValue()))) {
                LOG.debug("Set XSRF-TOKEN cookie");
                SyncopeEnduserSession.get().setXsrfTokenGenerated(true);
                sessionCookieUtils.save("XSRF-TOKEN", SaltGenerator.generate(SyncopeEnduserSession.get().getId()));
            }
            response.setTextEncoding("UTF-8");
            response.setWriteCallback(new AbstractResource.WriteCallback(){

                public void writeData(IResource.Attributes attributes) throws IOException {
                    attributes.getResponse().write((CharSequence)AbstractBaseResource.MAPPER.writeValueAsString((Object)PlatformInfoAdapter.toPlatformInfoRequest(SyncopeEnduserSession.get().getPlatformInfo())));
                }
            });
            response.setStatusCode(Integer.valueOf(Response.Status.OK.getStatusCode()));
        }
        catch (Exception e) {
            LOG.error("Error retrieving syncope info", (Throwable)e);
            response.setError(Integer.valueOf(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()), "ErrorMessage{{ " + e.getMessage() + " }}");
        }
        return response;
    }
}

