/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.resources;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.enduser.SyncopeEnduserApplication;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.model.Credentials;
import org.apache.syncope.client.enduser.resources.AbstractBaseResource;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.util.io.IOUtils;

public class LoginResource
extends AbstractBaseResource {
    private static final long serialVersionUID = -7720997467070461915L;

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
        try {
            HttpServletRequest request = (HttpServletRequest)attributes.getRequest().getContainerRequest();
            if (!this.xsrfCheck(request)) {
                LOG.error("XSRF TOKEN does not match");
                response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "XSRF TOKEN does not match");
                return response;
            }
            Credentials credentials = (Credentials)MAPPER.readValue(IOUtils.toString((InputStream)request.getInputStream()), Credentials.class);
            final String username = credentials.getUsername();
            String password = credentials.getPassword().isEmpty() ? null : credentials.getPassword();
            LOG.debug("Enduser login, user: {}", (Object)username);
            if (StringUtils.isBlank((CharSequence)username)) {
                LOG.error("Could not read credentials from request: username is blank!");
                response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "ErrorMessage{{ Could not read credentials from request: username is blank! }}");
            } else if (!SyncopeEnduserApplication.get().getAdminUser().equalsIgnoreCase(username) && SyncopeEnduserSession.get().authenticate(username, password)) {
                response.setTextEncoding("UTF-8");
                response.setWriteCallback(new AbstractResource.WriteCallback(){

                    public void writeData(IResource.Attributes attributes) throws IOException {
                        attributes.getResponse().write((CharSequence)username);
                    }
                });
                response.setStatusCode(Integer.valueOf(Response.Status.OK.getStatusCode()));
            } else {
                response.setError(Integer.valueOf(Response.Status.UNAUTHORIZED.getStatusCode()), "ErrorMessage{{ Username or password are incorrect }}");
            }
        }
        catch (Exception e) {
            LOG.error("Could not read credentials from request", (Throwable)e);
            response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "ErrorMessage{{ " + e.getMessage() + " }}");
        }
        return response;
    }
}

