/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.resources;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.commons.collections4.ComparatorUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.Transformer;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.model.SchemaResponse;
import org.apache.syncope.client.enduser.resources.AbstractBaseResource;
import org.apache.syncope.common.lib.EntityTOUtils;
import org.apache.syncope.common.lib.to.AbstractSchemaTO;
import org.apache.syncope.common.lib.to.AnyTypeTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.syncope.common.rest.api.beans.AnyQuery;
import org.apache.syncope.common.rest.api.beans.SchemaQuery;
import org.apache.syncope.common.rest.api.service.AnyTypeService;
import org.apache.syncope.common.rest.api.service.GroupService;
import org.apache.syncope.common.rest.api.service.SchemaService;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;

public class SchemaResource
extends AbstractBaseResource {
    private static final long serialVersionUID = 6453101466981543020L;
    private final AnyTypeService anyTypeService = SyncopeEnduserSession.get().getService(AnyTypeService.class);
    private final SchemaService schemaService = SyncopeEnduserSession.get().getService(SchemaService.class);
    private final GroupService groupService = SyncopeEnduserSession.get().getService(GroupService.class);

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        LOG.debug("Search all {} any type kind related schemas", (Object)AnyTypeKind.USER.name());
        AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
        try {
            List virSchemas;
            HttpServletRequest request = (HttpServletRequest)attributes.getRequest().getContainerRequest();
            if (!this.xsrfCheck(request)) {
                LOG.error("XSRF TOKEN does not match");
                response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "XSRF TOKEN does not match");
                return response;
            }
            List<Object> classes = Collections.emptyList();
            final String groupParam = attributes.getParameters().get("group").toString();
            if (groupParam != null) {
                PagedResult groups = this.groupService.search((AnyQuery)((AnyQuery.Builder)((AnyQuery.Builder)new AnyQuery.Builder().realm("/").page(Integer.valueOf(1))).size(Integer.valueOf(1000))).build());
                GroupTO group = (GroupTO)IterableUtils.find((Iterable)groups.getResult(), (Predicate)new Predicate<GroupTO>(){

                    public boolean evaluate(GroupTO item) {
                        return groupParam.equals(item.getName());
                    }
                });
                if (group != null && group.getTypeExtension(AnyTypeKind.USER.name()) != null) {
                    classes = group.getTypeExtension(AnyTypeKind.USER.name()).getAuxClasses();
                }
            } else {
                String anyTypeClass = attributes.getParameters().get("anyTypeClass").toString();
                if (anyTypeClass != null) {
                    classes = Collections.singletonList(anyTypeClass);
                } else {
                    AnyTypeTO anyTypeUserTO = this.anyTypeService.read(AnyTypeKind.USER.name());
                    classes = anyTypeUserTO.getClasses();
                }
            }
            final List plainSchemas = classes.isEmpty() ? Collections.emptyList() : this.schemaService.list(new SchemaQuery.Builder().type(SchemaType.PLAIN).anyTypeClasses(classes).build());
            final List derSchemas = classes.isEmpty() ? Collections.emptyList() : this.schemaService.list(new SchemaQuery.Builder().type(SchemaType.DERIVED).anyTypeClasses(classes).build());
            List list = virSchemas = classes.isEmpty() ? Collections.emptyList() : this.schemaService.list(new SchemaQuery.Builder().type(SchemaType.VIRTUAL).anyTypeClasses(classes).build());
            if (groupParam != null) {
                for (AbstractSchemaTO schema : plainSchemas) {
                    schema.setKey(groupParam + "#" + schema.getKey());
                }
                for (AbstractSchemaTO schema : derSchemas) {
                    schema.setKey(groupParam + "#" + schema.getKey());
                }
                for (AbstractSchemaTO schema : virSchemas) {
                    schema.setKey(groupParam + "#" + schema.getKey());
                }
            }
            Collections.sort(plainSchemas, ComparatorUtils.transformedComparator((Comparator)ComparatorUtils.naturalComparator(), (Transformer)EntityTOUtils.keyTransformer()));
            Collections.sort(derSchemas, ComparatorUtils.transformedComparator((Comparator)ComparatorUtils.naturalComparator(), (Transformer)EntityTOUtils.keyTransformer()));
            Collections.sort(virSchemas, ComparatorUtils.transformedComparator((Comparator)ComparatorUtils.naturalComparator(), (Transformer)EntityTOUtils.keyTransformer()));
            response.setTextEncoding("UTF-8");
            response.setWriteCallback(new AbstractResource.WriteCallback(){

                public void writeData(IResource.Attributes attributes) throws IOException {
                    attributes.getResponse().write((CharSequence)AbstractBaseResource.MAPPER.writeValueAsString((Object)new SchemaResponse().plainSchemas(plainSchemas).derSchemas(derSchemas).virSchemas(virSchemas)));
                }
            });
            response.setStatusCode(Integer.valueOf(Response.Status.OK.getStatusCode()));
        }
        catch (Exception e) {
            LOG.error("Error retrieving {} any type kind related schemas", (Object)AnyTypeKind.USER.name(), (Object)e);
            response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "ErrorMessage{{ " + e.getMessage() + " }}");
        }
        return response;
    }
}

