/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.resources;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.resources.AbstractBaseResource;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.rest.api.service.UserSelfService;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserSelfCreateResource
extends AbstractBaseResource {
    private static final long serialVersionUID = -2721621682300247583L;
    private static final Logger LOG = LoggerFactory.getLogger(UserSelfCreateResource.class);
    private final UserSelfService userSelfService = SyncopeEnduserSession.get().getService(UserSelfService.class);

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        final StringBuilder responseMessage = new StringBuilder();
        AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
        try {
            HttpServletRequest request = (HttpServletRequest)attributes.getRequest().getContainerRequest();
            if (!this.xsrfCheck(request)) {
                LOG.error("XSRF TOKEN is not matching");
                response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "XSRF TOKEN is not matching");
                return response;
            }
            String jsonString = request.getReader().readLine();
            final UserTO userTO = (UserTO)MAPPER.readValue(jsonString, UserTO.class);
            if (!this.captchaCheck(request.getHeader("captcha"), request.getSession().getAttribute("captcha"))) {
                throw new IllegalArgumentException("Entered captcha is not matching");
            }
            if (this.isSelfRegistrationAllowed() && userTO != null) {
                AttrTO clone;
                MembershipTO membership;
                String[] simpleAttrs;
                Map userPlainAttrMap = userTO.getPlainAttrMap();
                for (PlainSchemaTO plainSchemaTO : SyncopeEnduserSession.get().getDatePlainSchemas()) {
                    if (!userPlainAttrMap.containsKey(plainSchemaTO.getKey())) continue;
                    FastDateFormat fmt = FastDateFormat.getInstance((String)plainSchemaTO.getConversionPattern());
                    AttrTO dateAttr = (AttrTO)userPlainAttrMap.get(plainSchemaTO.getKey());
                    ArrayList<String> formattedValues = new ArrayList<String>(dateAttr.getValues().size());
                    for (String value : dateAttr.getValues()) {
                        try {
                            formattedValues.add(fmt.format((Object)Long.valueOf(value)));
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException("Invalid format value for " + value);
                        }
                    }
                    dateAttr.getValues().clear();
                    dateAttr.getValues().addAll(formattedValues);
                }
                HashSet<AttrTO> membAttrs = new HashSet<AttrTO>();
                for (AttrTO attr : userTO.getPlainAttrs()) {
                    if (!attr.getSchema().contains("#")) continue;
                    simpleAttrs = attr.getSchema().split("#");
                    membership = (MembershipTO)IterableUtils.find((Iterable)userTO.getMemberships(), (Predicate)new Predicate<MembershipTO>(){

                        public boolean evaluate(MembershipTO item) {
                            return simpleAttrs[0].equals(item.getGroupName());
                        }
                    });
                    if (membership == null) {
                        membership = new MembershipTO.Builder().group(null, simpleAttrs[0]).build();
                        userTO.getMemberships().add(membership);
                    }
                    clone = (AttrTO)SerializationUtils.clone((Serializable)attr);
                    clone.setSchema(simpleAttrs[1]);
                    membership.getPlainAttrs().add(clone);
                    membAttrs.add(attr);
                }
                userTO.getPlainAttrs().removeAll(membAttrs);
                membAttrs.clear();
                for (AttrTO attr : userTO.getDerAttrs()) {
                    if (!attr.getSchema().contains("#")) continue;
                    simpleAttrs = attr.getSchema().split("#");
                    membership = (MembershipTO)IterableUtils.find((Iterable)userTO.getMemberships(), (Predicate)new Predicate<MembershipTO>(){

                        public boolean evaluate(MembershipTO item) {
                            return simpleAttrs[0].equals(item.getGroupName());
                        }
                    });
                    if (membership == null) {
                        membership = new MembershipTO.Builder().group(null, simpleAttrs[0]).build();
                        userTO.getMemberships().add(membership);
                    }
                    clone = (AttrTO)SerializationUtils.clone((Serializable)attr);
                    clone.setSchema(simpleAttrs[1]);
                    membership.getDerAttrs().add(clone);
                    membAttrs.add(attr);
                }
                userTO.getDerAttrs().removeAll(membAttrs);
                membAttrs.clear();
                for (AttrTO attr : userTO.getVirAttrs()) {
                    if (!attr.getSchema().contains("#")) continue;
                    simpleAttrs = attr.getSchema().split("#");
                    membership = (MembershipTO)IterableUtils.find((Iterable)userTO.getMemberships(), (Predicate)new Predicate<MembershipTO>(){

                        public boolean evaluate(MembershipTO item) {
                            return simpleAttrs[0].equals(item.getGroupName());
                        }
                    });
                    if (membership == null) {
                        membership = new MembershipTO.Builder().group(null, simpleAttrs[0]).build();
                        userTO.getMemberships().add(membership);
                    }
                    clone = (AttrTO)SerializationUtils.clone((Serializable)attr);
                    clone.setSchema(simpleAttrs[1]);
                    membership.getVirAttrs().add(clone);
                    membAttrs.add(attr);
                }
                userTO.getVirAttrs().removeAll(membAttrs);
                LOG.debug("Received user self registration request for user: [{}]", (Object)userTO.getUsername());
                LOG.trace("Received user self registration request is: [{}]", (Object)userTO);
                final Response response2 = this.userSelfService.create(userTO, true);
                response.setTextEncoding("UTF-8");
                response.setWriteCallback(new AbstractResource.WriteCallback(){

                    public void writeData(IResource.Attributes attributes) throws IOException {
                        attributes.getResponse().write((CharSequence)(response2.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL) ? responseMessage.append("User: ").append(userTO.getUsername()).append(" successfully created") : new StringBuilder().append("ErrorMessage{{ ").append(response2.getStatusInfo().getReasonPhrase()).append(" }}")));
                    }
                });
                response.setStatusCode(Integer.valueOf(response2.getStatus()));
            } else {
                response.setError(Integer.valueOf(Response.Status.FORBIDDEN.getStatusCode()), "ErrorMessage{{" + (userTO == null ? "Request received is not valid }}" : "Self registration not allowed }}"));
            }
        }
        catch (Exception e) {
            LOG.error("Could not create userTO", (Throwable)e);
            response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "ErrorMessage{{ " + e.getMessage() + " }}");
        }
        return response;
    }
}

