/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.resources;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.syncope.client.enduser.resources.BaseResource;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;

public abstract class BaseUserSelfResource
extends BaseResource {
    private static final long serialVersionUID = -5892402817902884085L;

    protected void dateToMillis(Map<String, AttrTO> plainAttrMap, PlainSchemaTO plainSchema) throws ParseException {
        if (plainAttrMap.containsKey(plainSchema.getKey())) {
            FastDateFormat fmt = FastDateFormat.getInstance((String)plainSchema.getConversionPattern());
            AttrTO dateAttr = plainAttrMap.get(plainSchema.getKey());
            ArrayList<String> milliValues = new ArrayList<String>(dateAttr.getValues().size());
            for (String value : dateAttr.getValues()) {
                milliValues.add(String.valueOf(fmt.parse(value).getTime()));
            }
            dateAttr.getValues().clear();
            dateAttr.getValues().addAll(milliValues);
        }
    }

    protected void millisToDate(Map<String, AttrTO> plainAttrMap, PlainSchemaTO plainSchema) throws IllegalArgumentException {
        if (plainAttrMap.containsKey(plainSchema.getKey())) {
            FastDateFormat fmt = FastDateFormat.getInstance((String)plainSchema.getConversionPattern());
            AttrTO dateAttr = plainAttrMap.get(plainSchema.getKey());
            ArrayList<String> formattedValues = new ArrayList<String>(dateAttr.getValues().size());
            for (String value : dateAttr.getValues()) {
                try {
                    formattedValues.add(fmt.format((Object)Long.valueOf(value)));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid format value for " + value);
                }
            }
            dateAttr.getValues().clear();
            dateAttr.getValues().addAll(formattedValues);
        }
    }

    protected void buildResponse(AbstractResource.ResourceResponse response, int statusCode, final String message) {
        response.setTextEncoding(StandardCharsets.UTF_8.name());
        response.setStatusCode(Integer.valueOf(statusCode));
        response.setWriteCallback(new AbstractResource.WriteCallback(){

            public void writeData(IResource.Attributes attributes) throws IOException {
                attributes.getResponse().write((CharSequence)message);
            }
        });
    }
}

