/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.resources;

import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.syncope.client.enduser.SyncopeEnduserApplication;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.annotations.Resource;
import org.apache.syncope.client.enduser.model.CustomAttribute;
import org.apache.syncope.client.enduser.model.CustomAttributesInfo;
import org.apache.syncope.client.enduser.resources.BaseUserSelfResource;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;

@Resource(key="userSelfRead", path="/api/self/read")
public class UserSelfReadResource
extends BaseUserSelfResource {
    private static final long serialVersionUID = -9184809392631523912L;

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        LOG.debug("Requested user self information");
        AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
        response.setContentType("application/json");
        try {
            HttpServletRequest request = (HttpServletRequest)attributes.getRequest().getContainerRequest();
            if (!this.xsrfCheck(request)) {
                LOG.error("XSRF TOKEN does not match");
                response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "XSRF TOKEN does not match");
                return response;
            }
            UserTO userTO = (UserTO)SerializationUtils.clone((Serializable)SyncopeEnduserSession.get().getSelfTO());
            Map userPlainAttrMap = userTO.getPlainAttrMap();
            for (PlainSchemaTO plainSchema : SyncopeEnduserSession.get().getDatePlainSchemas()) {
                this.dateToMillis(userPlainAttrMap, plainSchema);
                for (MembershipTO membership : userTO.getMemberships()) {
                    this.dateToMillis(membership.getPlainAttrMap(), plainSchema);
                }
            }
            for (MembershipTO membership : userTO.getMemberships()) {
                String groupName = membership.getGroupName();
                for (AttrTO attr : membership.getPlainAttrs()) {
                    attr.setSchema(groupName.concat("#").concat(attr.getSchema()));
                    userTO.getPlainAttrs().add(attr);
                }
                membership.getPlainAttrs().clear();
                for (AttrTO attr : membership.getDerAttrs()) {
                    attr.setSchema(groupName.concat("#").concat(attr.getSchema()));
                    userTO.getDerAttrs().add(attr);
                }
                membership.getDerAttrs().clear();
                for (AttrTO attr : membership.getVirAttrs()) {
                    attr.setSchema(groupName.concat("#").concat(attr.getSchema()));
                    userTO.getVirAttrs().add(attr);
                }
                membership.getVirAttrs().clear();
            }
            Map<String, CustomAttributesInfo> customForm = SyncopeEnduserApplication.get().getCustomForm();
            if (customForm != null && !customForm.isEmpty()) {
                this.customizeAttrs(userTO.getPlainAttrs(), customForm.get(SchemaType.PLAIN.name()).getAttributes());
                this.customizeAttrs(userTO.getDerAttrs(), customForm.get(SchemaType.DERIVED.name()).getAttributes());
                this.customizeAttrs(userTO.getVirAttrs(), customForm.get(SchemaType.VIRTUAL.name()).getAttributes());
            }
            final String selfTOJson = MAPPER.writeValueAsString((Object)userTO);
            response.setContentType("application/json");
            response.setTextEncoding(StandardCharsets.UTF_8.name());
            response.setWriteCallback(new AbstractResource.WriteCallback(){

                public void writeData(IResource.Attributes attributes) throws IOException {
                    attributes.getResponse().write((CharSequence)selfTOJson);
                }
            });
            response.setStatusCode(Integer.valueOf(Response.Status.OK.getStatusCode()));
        }
        catch (Exception e) {
            LOG.error("Error retrieving selfTO", (Throwable)e);
            response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "ErrorMessage{{ " + e.getMessage() + " }}");
        }
        return response;
    }

    private void customizeAttrs(Set<AttrTO> attrs, final Map<String, CustomAttribute> customForm) {
        CollectionUtils.filter(attrs, (Predicate)new Predicate<AttrTO>(){

            public boolean evaluate(AttrTO attr) {
                return customForm.containsKey(attr.getSchema());
            }
        });
    }
}

