/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.resources;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.annotations.Resource;
import org.apache.syncope.client.enduser.resources.BaseUserSelfResource;
import org.apache.syncope.client.enduser.util.UserRequestValidator;
import org.apache.syncope.common.lib.AnyOperations;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.rest.api.service.UserSelfService;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;

@Resource(key="userSelfUpdate", path="/api/self/update")
public class UserSelfUpdateResource
extends BaseUserSelfResource {
    private static final long serialVersionUID = -2721621682300247583L;

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
        response.setContentType("text/plain");
        try {
            HttpServletRequest request = (HttpServletRequest)attributes.getRequest().getContainerRequest();
            if (!this.xsrfCheck(request)) {
                LOG.error("XSRF TOKEN does not match");
                response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "XSRF TOKEN does not match");
                return response;
            }
            if (!this.captchaCheck(request.getHeader("captcha"), request.getSession().getAttribute("captcha"))) {
                throw new IllegalArgumentException("Entered captcha is not matching");
            }
            UserTO userTO = (UserTO)MAPPER.readValue(request.getReader().readLine(), UserTO.class);
            if (UserRequestValidator.compliant(userTO, SyncopeEnduserSession.get().getCustomForm(), false)) {
                AttrTO clone;
                String[] simpleAttrs;
                MembershipTO membership3;
                HashSet<Object> membAttrs = new HashSet<Object>();
                for (Object attr : userTO.getPlainAttrs()) {
                    if (!attr.getSchema().contains("#")) continue;
                    final String[] compositeSchemaKey = attr.getSchema().split("#");
                    Object membership2 = (MembershipTO)IterableUtils.find((Iterable)userTO.getMemberships(), (Predicate)new Predicate<MembershipTO>(){

                        public boolean evaluate(MembershipTO item) {
                            return compositeSchemaKey[0].equals(item.getGroupName());
                        }
                    });
                    if (membership2 == null) {
                        membership2 = new MembershipTO.Builder().group(null, compositeSchemaKey[0]).build();
                        userTO.getMemberships().add(membership2);
                    }
                    AttrTO clone2 = (AttrTO)SerializationUtils.clone((Serializable)attr);
                    clone2.setSchema(compositeSchemaKey[1]);
                    membership2.getPlainAttrs().add(clone2);
                    membAttrs.add(attr);
                }
                userTO.getPlainAttrs().removeAll(membAttrs);
                Map userPlainAttrMap = userTO.getPlainAttrMap();
                for (PlainSchemaTO plainSchema : SyncopeEnduserSession.get().getDatePlainSchemas()) {
                    this.millisToDate(userPlainAttrMap, plainSchema);
                    for (MembershipTO membership3 : userTO.getMemberships()) {
                        this.millisToDate(membership3.getPlainAttrMap(), plainSchema);
                    }
                }
                membAttrs.clear();
                for (AttrTO attr : userTO.getDerAttrs()) {
                    if (!attr.getSchema().contains("#")) continue;
                    simpleAttrs = attr.getSchema().split("#");
                    membership3 = (MembershipTO)IterableUtils.find((Iterable)userTO.getMemberships(), (Predicate)new Predicate<MembershipTO>(){

                        public boolean evaluate(MembershipTO item) {
                            return simpleAttrs[0].equals(item.getGroupName());
                        }
                    });
                    if (membership3 == null) {
                        membership3 = new MembershipTO.Builder().group(null, simpleAttrs[0]).build();
                        userTO.getMemberships().add(membership3);
                    }
                    clone = (AttrTO)SerializationUtils.clone((Serializable)attr);
                    clone.setSchema(simpleAttrs[1]);
                    membership3.getDerAttrs().add(clone);
                    membAttrs.add(attr);
                }
                userTO.getDerAttrs().removeAll(membAttrs);
                membAttrs.clear();
                for (AttrTO attr : userTO.getVirAttrs()) {
                    if (!attr.getSchema().contains("#")) continue;
                    simpleAttrs = attr.getSchema().split("#");
                    membership3 = (MembershipTO)IterableUtils.find((Iterable)userTO.getMemberships(), (Predicate)new Predicate<MembershipTO>(){

                        public boolean evaluate(MembershipTO item) {
                            return simpleAttrs[0].equals(item.getGroupName());
                        }
                    });
                    if (membership3 == null) {
                        membership3 = new MembershipTO.Builder().group(null, simpleAttrs[0]).build();
                        userTO.getMemberships().add(membership3);
                    }
                    clone = (AttrTO)SerializationUtils.clone((Serializable)attr);
                    clone.setSchema(simpleAttrs[1]);
                    membership3.getVirAttrs().add(clone);
                    membAttrs.add(attr);
                }
                userTO.getVirAttrs().removeAll(membAttrs);
                Response res = SyncopeEnduserSession.get().getService(userTO.getETagValue(), UserSelfService.class).update(AnyOperations.diff((UserTO)userTO, (UserTO)SyncopeEnduserSession.get().getSelfTO(), (boolean)true));
                this.buildResponse(response, res.getStatus(), res.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL) ? "User [" + userTO.getUsername() + "] successfully updated" : "ErrorMessage{{ " + res.getStatusInfo().getReasonPhrase() + " }}");
            } else {
                LOG.warn("Incoming update request [{}] is not compliant with form customization rules. Update NOT allowed", (Object)userTO.getUsername());
                this.buildResponse(response, Response.Status.OK.getStatusCode(), "User: " + userTO.getUsername() + " successfully created");
            }
        }
        catch (Exception e) {
            LOG.error("Error while updating user", (Throwable)e);
            response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "ErrorMessage{{ " + e.getMessage() + " }}");
        }
        return response;
    }
}

