/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.resources;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.enduser.SyncopeEnduserApplication;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.annotations.Resource;
import org.apache.syncope.client.enduser.model.CustomAttribute;
import org.apache.syncope.client.enduser.model.CustomAttributesInfo;
import org.apache.syncope.client.enduser.model.SchemaResponse;
import org.apache.syncope.client.enduser.resources.BaseResource;
import org.apache.syncope.common.lib.to.AbstractSchemaTO;
import org.apache.syncope.common.lib.to.AnyTypeTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.syncope.common.rest.api.beans.AnyQuery;
import org.apache.syncope.common.rest.api.beans.SchemaQuery;
import org.apache.syncope.common.rest.api.service.AnyTypeService;
import org.apache.syncope.common.rest.api.service.GroupService;
import org.apache.syncope.common.rest.api.service.SchemaService;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;

@Resource(key="schemas", path="/api/schemas")
public class SchemaResource
extends BaseResource {
    private static final long serialVersionUID = 6453101466981543020L;

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        LOG.debug("Search all {} any type kind related schemas", (Object)AnyTypeKind.USER.name());
        AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
        response.setContentType("application/json");
        try {
            List<AbstractSchemaTO> virSchemas;
            List<AbstractSchemaTO> derSchemas;
            List<AbstractSchemaTO> plainSchemas;
            HttpServletRequest request = (HttpServletRequest)attributes.getRequest().getContainerRequest();
            if (!this.xsrfCheck(request)) {
                LOG.error("XSRF TOKEN does not match");
                response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "XSRF TOKEN does not match");
                return response;
            }
            List classes = Collections.emptyList();
            final String groupParam = attributes.getParameters().get("group").toString();
            if (groupParam != null) {
                PagedResult groups = SyncopeEnduserSession.get().getService(GroupService.class).search((AnyQuery)((AnyQuery.Builder)((AnyQuery.Builder)new AnyQuery.Builder().realm("/").page(Integer.valueOf(1))).size(Integer.valueOf(1000))).build());
                GroupTO group = (GroupTO)IterableUtils.find((Iterable)groups.getResult(), (Predicate)new Predicate<GroupTO>(){

                    public boolean evaluate(GroupTO item) {
                        return groupParam.equals(item.getName());
                    }
                });
                if (group != null && group.getTypeExtension(AnyTypeKind.USER.name()) != null) {
                    classes = group.getTypeExtension(AnyTypeKind.USER.name()).getAuxClasses();
                }
            } else {
                String anyTypeClass = attributes.getParameters().get("anyTypeClass").toString();
                if (anyTypeClass != null) {
                    classes = Collections.singletonList(anyTypeClass);
                } else {
                    AnyTypeTO anyTypeUserTO = SyncopeEnduserSession.get().getService(AnyTypeService.class).read(AnyTypeKind.USER.name());
                    classes = anyTypeUserTO.getClasses();
                }
            }
            Map<String, CustomAttributesInfo> customForm = SyncopeEnduserApplication.get().getCustomForm();
            SchemaService schemaService = SyncopeEnduserSession.get().getService(SchemaService.class);
            List<AbstractSchemaTO> list = classes.isEmpty() ? Collections.emptyList() : (customForm == null || customForm.isEmpty() || customForm.get(SchemaType.PLAIN.name()) == null ? schemaService.list(new SchemaQuery.Builder().type(SchemaType.PLAIN).anyTypeClasses((Collection)classes).build()) : (plainSchemas = customForm.get(SchemaType.PLAIN.name()).isShow() != false ? this.customizeSchemas(schemaService.list(new SchemaQuery.Builder().type(SchemaType.PLAIN).anyTypeClasses((Collection)classes).build()), groupParam, customForm.get(SchemaType.PLAIN.name()).getAttributes()) : Collections.emptyList()));
            List<AbstractSchemaTO> list2 = classes.isEmpty() ? Collections.emptyList() : (customForm == null || customForm.isEmpty() || customForm.get(SchemaType.DERIVED.name()) == null ? schemaService.list(new SchemaQuery.Builder().type(SchemaType.DERIVED).anyTypeClasses((Collection)classes).build()) : (derSchemas = customForm.get(SchemaType.DERIVED.name()).isShow() != false ? this.customizeSchemas(schemaService.list(new SchemaQuery.Builder().type(SchemaType.DERIVED).anyTypeClasses((Collection)classes).build()), groupParam, customForm.get(SchemaType.DERIVED.name()).getAttributes()) : Collections.emptyList()));
            List<AbstractSchemaTO> list3 = classes.isEmpty() ? Collections.emptyList() : (customForm == null || customForm.isEmpty() || customForm.get(SchemaType.VIRTUAL.name()) == null ? schemaService.list(new SchemaQuery.Builder().type(SchemaType.VIRTUAL).anyTypeClasses((Collection)classes).build()) : (virSchemas = customForm.get(SchemaType.VIRTUAL.name()).isShow() != false ? this.customizeSchemas(schemaService.list(new SchemaQuery.Builder().type(SchemaType.VIRTUAL).anyTypeClasses((Collection)classes).build()), groupParam, customForm.get(SchemaType.VIRTUAL.name()).getAttributes()) : Collections.emptyList()));
            if (groupParam != null) {
                for (AbstractSchemaTO schema : plainSchemas) {
                    schema.setKey(this.compositeSchemaKey(groupParam, schema.getKey()));
                }
                for (AbstractSchemaTO schema : derSchemas) {
                    schema.setKey(this.compositeSchemaKey(groupParam, schema.getKey()));
                }
                for (AbstractSchemaTO schema : virSchemas) {
                    schema.setKey(this.compositeSchemaKey(groupParam, schema.getKey()));
                }
            }
            response.setTextEncoding(StandardCharsets.UTF_8.name());
            response.setWriteCallback(new AbstractResource.WriteCallback(){

                public void writeData(IResource.Attributes attributes) throws IOException {
                    attributes.getResponse().write((CharSequence)BaseResource.MAPPER.writeValueAsString((Object)new SchemaResponse().plainSchemas(plainSchemas).derSchemas(derSchemas).virSchemas(virSchemas)));
                }
            });
            response.setStatusCode(Integer.valueOf(Response.Status.OK.getStatusCode()));
        }
        catch (Exception e) {
            LOG.error("Error retrieving {} any type kind related schemas", (Object)AnyTypeKind.USER.name(), (Object)e);
            response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "ErrorMessage{{ " + e.getMessage() + " }}");
        }
        return response;
    }

    private List<AbstractSchemaTO> customizeSchemas(List<AbstractSchemaTO> schemaTOs, final String groupParam, final Map<String, CustomAttribute> customForm) {
        if (customForm.isEmpty()) {
            return schemaTOs;
        }
        final boolean isGroupBlank = StringUtils.isBlank((CharSequence)groupParam);
        CollectionUtils.filter(schemaTOs, (Predicate)new Predicate<AbstractSchemaTO>(){

            public boolean evaluate(AbstractSchemaTO object) {
                return customForm.containsKey(isGroupBlank ? object.getKey() : SchemaResource.this.compositeSchemaKey(groupParam, object.getKey()));
            }
        });
        Collections.sort(schemaTOs, new Comparator<AbstractSchemaTO>(){

            @Override
            public int compare(AbstractSchemaTO schemaTO1, AbstractSchemaTO schemaTO2) {
                ArrayList order = new ArrayList(customForm.keySet());
                return order.indexOf(isGroupBlank ? schemaTO1.getKey() : SchemaResource.this.compositeSchemaKey(groupParam, schemaTO1.getKey())) - order.indexOf(isGroupBlank ? schemaTO2.getKey() : SchemaResource.this.compositeSchemaKey(groupParam, schemaTO2.getKey()));
            }
        });
        return schemaTOs;
    }

    private String compositeSchemaKey(String prefix, String schemaKey) {
        return prefix + "#" + schemaKey;
    }
}

