/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.resources;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.annotations.Resource;
import org.apache.syncope.client.enduser.resources.BaseResource;
import org.apache.syncope.common.rest.api.service.UserSelfService;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;

@Resource(key="userSelfPasswordReset", path="/api/self/requestPasswordReset")
public class UserSelfPasswordReset
extends BaseResource {
    private static final long serialVersionUID = -2721621682300247583L;

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
        response.setContentType("application/json");
        try {
            HttpServletRequest request = (HttpServletRequest)attributes.getRequest().getContainerRequest();
            if (!this.xsrfCheck(request)) {
                LOG.error("XSRF TOKEN does not match");
                response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "XSRF TOKEN does not match");
                return response;
            }
            Map parameters = request.getParameterMap();
            Object[] usernameParam = (String[])parameters.get("username");
            if (ArrayUtils.isEmpty((Object[])usernameParam)) {
                throw new Exception("A valid username should be provided");
            }
            if (request.getHeader("captcha") == null || !this.captchaCheck(request.getHeader("captcha"), request.getSession().getAttribute("captcha"))) {
                throw new IllegalArgumentException("Entered captcha is not matching");
            }
            if (SyncopeEnduserSession.get().getPlatformInfo().isPwdResetRequiringSecurityQuestions()) {
                Object[] securityAnswerParam = (String[])parameters.get("securityAnswer");
                if (ArrayUtils.isEmpty((Object[])securityAnswerParam)) {
                    throw new Exception("A correct security answer should be provided");
                }
                SyncopeEnduserSession.get().getService(UserSelfService.class).requestPasswordReset((String)usernameParam[0], (String)securityAnswerParam[0]);
            } else {
                SyncopeEnduserSession.get().getService(UserSelfService.class).requestPasswordReset((String)usernameParam[0], null);
            }
            final String responseMessage = "Password reset request sent for user " + (String)usernameParam[0];
            response.setTextEncoding(StandardCharsets.UTF_8.name());
            response.setWriteCallback(new AbstractResource.WriteCallback(){

                public void writeData(IResource.Attributes attributes) throws IOException {
                    attributes.getResponse().write((CharSequence)responseMessage);
                }
            });
            response.setStatusCode(Integer.valueOf(Response.Status.OK.getStatusCode()));
        }
        catch (Exception e) {
            LOG.error("Error while updating user", (Throwable)e);
            response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "ErrorMessage{{ " + e.getMessage() + " }}");
        }
        return response;
    }
}

