/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.resources;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.syncope.client.enduser.resources.BaseResource;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;

public abstract class BaseUserSelfResource
extends BaseResource {
    private static final long serialVersionUID = -5892402817902884085L;

    protected void dateToMillis(Set<AttrTO> attrs, PlainSchemaTO plainSchema) throws ParseException {
        final FastDateFormat fmt = FastDateFormat.getInstance((String)plainSchema.getConversionPattern());
        for (AttrTO attr : attrs) {
            if (!attr.getSchema().equals(plainSchema.getKey())) continue;
            CollectionUtils.transform((Collection)attr.getValues(), (Transformer)new Transformer<String, String>(){

                public String transform(String input) {
                    try {
                        return String.valueOf(fmt.parse(input).getTime());
                    }
                    catch (ParseException ex) {
                        BaseResource.LOG.error("Unable to parse date {}", (Object)input);
                        return input;
                    }
                }
            });
        }
    }

    protected void millisToDate(Set<AttrTO> attrs, PlainSchemaTO plainSchema) throws IllegalArgumentException {
        final FastDateFormat fmt = FastDateFormat.getInstance((String)plainSchema.getConversionPattern());
        for (AttrTO attr : attrs) {
            if (!attr.getSchema().equals(plainSchema.getKey())) continue;
            CollectionUtils.transform((Collection)attr.getValues(), (Transformer)new Transformer<String, String>(){

                public String transform(String input) {
                    try {
                        return fmt.format((Object)Long.valueOf(input));
                    }
                    catch (NumberFormatException ex) {
                        BaseResource.LOG.error("Invalid format value for {}", (Object)input);
                        return input;
                    }
                }
            });
        }
    }

    protected void buildResponse(AbstractResource.ResourceResponse response, int statusCode, final String message) {
        response.setTextEncoding(StandardCharsets.UTF_8.name());
        response.setStatusCode(Integer.valueOf(statusCode));
        response.setWriteCallback(new AbstractResource.WriteCallback(){

            public void writeData(IResource.Attributes attributes) throws IOException {
                attributes.getResponse().write((CharSequence)message);
            }
        });
    }
}

