/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser;

import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.EntityTag;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.syncope.client.enduser.SyncopeEnduserApplication;
import org.apache.syncope.client.lib.AnonymousAuthenticationHandler;
import org.apache.syncope.client.lib.AuthenticationHandler;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.common.lib.info.PlatformInfo;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.syncope.common.rest.api.beans.SchemaQuery;
import org.apache.syncope.common.rest.api.service.SchemaService;
import org.apache.syncope.common.rest.api.service.SyncopeService;
import org.apache.wicket.Session;
import org.apache.wicket.protocol.http.WebSession;
import org.apache.wicket.request.Request;
import org.apache.wicket.util.cookies.CookieUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncopeEnduserSession
extends WebSession {
    private static final long serialVersionUID = 1284946129513378647L;
    private static final Logger LOG = LoggerFactory.getLogger(SyncopeEnduserSession.class);
    private final SyncopeClient anonymousClient;
    private SyncopeClient client;
    private final PlatformInfo platformInfo;
    private final List<PlainSchemaTO> datePlainSchemas;
    private UserTO selfTO;
    private final CookieUtils cookieUtils = new CookieUtils();
    private boolean xsrfTokenGenerated = false;

    public static SyncopeEnduserSession get() {
        return (SyncopeEnduserSession)Session.get();
    }

    public SyncopeEnduserSession(Request request) {
        super(request);
        this.anonymousClient = SyncopeEnduserApplication.get().getClientFactory().create((AuthenticationHandler)new AnonymousAuthenticationHandler(SyncopeEnduserApplication.get().getAnonymousUser(), SyncopeEnduserApplication.get().getAnonymousKey()));
        this.platformInfo = ((SyncopeService)this.anonymousClient.getService(SyncopeService.class)).platform();
        this.datePlainSchemas = ((SchemaService)this.anonymousClient.getService(SchemaService.class)).search(new SchemaQuery.Builder().type(SchemaType.PLAIN).build());
        this.datePlainSchemas.removeAll(this.datePlainSchemas.stream().filter(object -> object.getType() != AttrSchemaType.Date).collect(Collectors.toSet()));
    }

    private void afterAuthentication() {
        Pair self = this.client.self();
        this.selfTO = (UserTO)self.getRight();
        this.bind();
    }

    public boolean authenticate(String username, String password) {
        boolean authenticated = false;
        try {
            this.client = SyncopeEnduserApplication.get().getClientFactory().setDomain(SyncopeEnduserApplication.get().getDomain()).create(username, password);
            this.afterAuthentication();
            authenticated = true;
        }
        catch (Exception e) {
            LOG.error("Authentication failed", (Throwable)e);
        }
        return authenticated;
    }

    public boolean authenticate(String jwt) {
        boolean authenticated = false;
        try {
            this.client = SyncopeEnduserApplication.get().getClientFactory().setDomain(SyncopeEnduserApplication.get().getDomain()).create(jwt);
            this.afterAuthentication();
            authenticated = true;
        }
        catch (Exception e) {
            LOG.error("Authentication failed", (Throwable)e);
        }
        return authenticated;
    }

    public void invalidate() {
        if (this.isAuthenticated()) {
            try {
                this.client.logout();
            }
            catch (Exception e) {
                LOG.debug("Unexpected exception while logging out", (Throwable)e);
            }
            finally {
                this.client = null;
                this.selfTO = null;
            }
        }
        super.invalidate();
    }

    public <T> T getService(Class<T> serviceClass) {
        return (T)(this.client == null || !this.isAuthenticated() ? this.anonymousClient.getService(serviceClass) : this.client.getService(serviceClass));
    }

    public <T> T getService(String etag, Class<T> serviceClass) {
        T serviceInstance = this.getService(serviceClass);
        WebClient.client(serviceInstance).match(new EntityTag(etag), false).type("application/json").accept(new String[]{"application/json"});
        return serviceInstance;
    }

    public PlatformInfo getPlatformInfo() {
        return this.platformInfo;
    }

    public List<PlainSchemaTO> getDatePlainSchemas() {
        return this.datePlainSchemas;
    }

    public UserTO getSelfTO() {
        if (this.selfTO == null) {
            throw new IllegalArgumentException("User not authenticated");
        }
        return this.selfTO;
    }

    public boolean isAuthenticated() {
        return this.client != null && this.client.getJWT() != null;
    }

    public CookieUtils getCookieUtils() {
        return this.cookieUtils;
    }

    public boolean isXsrfTokenGenerated() {
        return this.xsrfTokenGenerated;
    }

    public void setXsrfTokenGenerated(boolean xsrfTokenGenerated) {
        this.xsrfTokenGenerated = xsrfTokenGenerated;
    }
}

