/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.util;

import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.enduser.model.CustomAttribute;
import org.apache.syncope.client.enduser.model.CustomAttributesInfo;
import org.apache.syncope.client.enduser.model.CustomTemplateInfo;
import org.apache.syncope.common.lib.EntityTOUtils;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.SchemaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Validation {
    private static final Logger LOG = LoggerFactory.getLogger(Validation.class);

    public static boolean isCompliant(UserTO userTO, Map<String, CustomAttributesInfo> customFormAttributes, boolean checkDefaultValues) {
        if (customFormAttributes == null || customFormAttributes.isEmpty()) {
            return true;
        }
        return Validation.validateAttributes(EntityTOUtils.buildAttrMap((Collection)userTO.getPlainAttrs()), customFormAttributes.get(SchemaType.PLAIN.name()), checkDefaultValues) && Validation.validateAttributes(EntityTOUtils.buildAttrMap((Collection)userTO.getDerAttrs()), customFormAttributes.get(SchemaType.DERIVED.name()), checkDefaultValues) && Validation.validateAttributes(EntityTOUtils.buildAttrMap((Collection)userTO.getVirAttrs()), customFormAttributes.get(SchemaType.VIRTUAL.name()), checkDefaultValues);
    }

    private static boolean validateAttributes(Map<String, AttrTO> attrMap, CustomAttributesInfo customAttrInfo, boolean checkDefaultValues) {
        return customAttrInfo == null || customAttrInfo.getAttributes().isEmpty() || attrMap.entrySet().stream().allMatch(entry -> {
            boolean compliant;
            String schemaKey = (String)entry.getKey();
            AttrTO attrTO = (AttrTO)entry.getValue();
            CustomAttribute customAttr = customAttrInfo.getAttributes().get(schemaKey);
            boolean bl = compliant = customAttr != null && (!checkDefaultValues || Validation.isValid(attrTO, customAttr));
            if (!compliant) {
                LOG.trace("Attribute [{}] or its values [{}] are not allowed by form customization rules", (Object)attrTO.getSchema(), (Object)attrTO.getValues());
            }
            return compliant;
        });
    }

    public static boolean validateSteps(CustomTemplateInfo customTemplateInfo) {
        return customTemplateInfo != null && StringUtils.isNotBlank((CharSequence)customTemplateInfo.getWizard().getFirstStep()) && !customTemplateInfo.getWizard().getSteps().isEmpty();
    }

    public static boolean validateStep(String stepName, CustomTemplateInfo customTemplateInfo) {
        return customTemplateInfo != null && !customTemplateInfo.getWizard().getSteps().isEmpty() && customTemplateInfo.getWizard().getSteps().containsKey(stepName) && StringUtils.isNotBlank((CharSequence)customTemplateInfo.getWizard().getSteps().get(stepName).getUrl());
    }

    private static boolean isValid(AttrTO attrTO, CustomAttribute customAttribute) {
        return customAttribute.isReadonly() ? attrTO.getValues().stream().allMatch(value -> customAttribute.getDefaultValues().contains(value)) : true;
    }

    private Validation() {
    }
}

