/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.to;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.RelationshipTO;

@XmlRootElement(name="anyObject")
@XmlType
public class AnyObjectTO
extends AnyTO {
    private static final long serialVersionUID = 8841697496476959639L;
    private final List<RelationshipTO> relationships = new ArrayList<RelationshipTO>();
    private final List<MembershipTO> memberships = new ArrayList<MembershipTO>();
    private final List<Long> dynGroups = new ArrayList<Long>();

    @XmlElementWrapper(name="relationships")
    @XmlElement(name="relationship")
    @JsonProperty(value="relationships")
    public List<RelationshipTO> getRelationships() {
        return this.relationships;
    }

    @JsonIgnore
    public Map<Long, RelationshipTO> getRelationshipMap() {
        HashMap<Long, RelationshipTO> result = new HashMap(this.getRelationships().size());
        for (RelationshipTO membership : this.getRelationships()) {
            result.put(membership.getRightKey(), membership);
        }
        result = Collections.unmodifiableMap(result);
        return result;
    }

    @XmlElementWrapper(name="memberships")
    @XmlElement(name="membership")
    @JsonProperty(value="memberships")
    public List<MembershipTO> getMemberships() {
        return this.memberships;
    }

    @JsonIgnore
    public Map<Long, MembershipTO> getMembershipMap() {
        HashMap<Long, MembershipTO> result = new HashMap(this.getMemberships().size());
        for (MembershipTO membership : this.getMemberships()) {
            result.put(membership.getRightKey(), membership);
        }
        result = Collections.unmodifiableMap(result);
        return result;
    }

    @XmlElementWrapper(name="dynGroups")
    @XmlElement(name="role")
    @JsonProperty(value="dynGroups")
    public List<Long> getDynGroups() {
        return this.dynGroups;
    }
}

