/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.to;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.ConnObjectTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.UserTO;

@XmlRootElement(name="any")
@XmlType
@XmlSeeAlso(value={UserTO.class, GroupTO.class, AnyObjectTO.class})
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
public abstract class AnyTO
extends ConnObjectTO {
    private static final long serialVersionUID = -754311920679872084L;
    private long key;
    private String type;
    private String realm;
    private String status;
    private final List<String> auxClasses = new ArrayList<String>();
    private final Set<AttrTO> derAttrs = new HashSet<AttrTO>();
    private final Set<AttrTO> virAttrs = new HashSet<AttrTO>();
    private final Set<String> resources = new HashSet<String>();

    public long getKey() {
        return this.key;
    }

    public void setKey(long key) {
        this.key = key;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @XmlElementWrapper(name="auxClasses")
    @XmlElement(name="class")
    @JsonProperty(value="auxClasses")
    public List<String> getAuxClasses() {
        return this.auxClasses;
    }

    @XmlElementWrapper(name="derAttrs")
    @XmlElement(name="attribute")
    @JsonProperty(value="derAttrs")
    public Set<AttrTO> getDerAttrs() {
        return this.derAttrs;
    }

    @JsonIgnore
    public Map<String, AttrTO> getDerAttrMap() {
        HashMap<String, AttrTO> result = new HashMap<String, AttrTO>(this.derAttrs.size());
        for (AttrTO attributeTO : this.derAttrs) {
            result.put(attributeTO.getSchema(), attributeTO);
        }
        return Collections.unmodifiableMap(result);
    }

    @XmlElementWrapper(name="virAttrs")
    @XmlElement(name="attribute")
    @JsonProperty(value="virAttrs")
    public Set<AttrTO> getVirAttrs() {
        return this.virAttrs;
    }

    @JsonIgnore
    public Map<String, AttrTO> getVirAttrMap() {
        HashMap<String, AttrTO> result = new HashMap<String, AttrTO>(this.virAttrs.size());
        for (AttrTO attributeTO : this.virAttrs) {
            result.put(attributeTO.getSchema(), attributeTO);
        }
        return Collections.unmodifiableMap(result);
    }

    @XmlElementWrapper(name="resources")
    @XmlElement(name="resource")
    @JsonProperty(value="resources")
    public Set<String> getResources() {
        return this.resources;
    }
}

