/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.to;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.PathParam;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.syncope.common.lib.AbstractBaseBean;
import org.apache.syncope.common.lib.to.ConnPoolConfTO;
import org.apache.syncope.common.lib.types.ConnConfProperty;
import org.apache.syncope.common.lib.types.ConnectorCapability;

@XmlRootElement(name="connInstance")
@XmlType
public class ConnInstanceTO
extends AbstractBaseBean {
    private static final long serialVersionUID = 2707778645445168671L;
    private long key;
    private String location;
    private String connectorName;
    private String bundleName;
    private String version;
    private final Set<ConnConfProperty> conf = new HashSet<ConnConfProperty>();
    private final Set<ConnectorCapability> capabilities = EnumSet.noneOf(ConnectorCapability.class);
    private String displayName;
    private Integer connRequestTimeout;
    private ConnPoolConfTO poolConf;

    public long getKey() {
        return this.key;
    }

    @PathParam(value="key")
    public void setKey(long key) {
        this.key = key;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getConnectorName() {
        return this.connectorName;
    }

    public void setConnectorName(String connectorname) {
        this.connectorName = connectorname;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public void setBundleName(String bundlename) {
        this.bundleName = bundlename;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @XmlElementWrapper(name="conf")
    @XmlElement(name="property")
    @JsonProperty(value="conf")
    public Set<ConnConfProperty> getConf() {
        return this.conf;
    }

    @JsonIgnore
    public Map<String, ConnConfProperty> getConfMap() {
        Map<String, ConnConfProperty> result = new HashMap();
        for (ConnConfProperty prop : this.getConf()) {
            result.put(prop.getSchema().getName(), prop);
        }
        result = Collections.unmodifiableMap(result);
        return Collections.unmodifiableMap(result);
    }

    @XmlElementWrapper(name="capabilities")
    @XmlElement(name="capability")
    @JsonProperty(value="capabilities")
    public Set<ConnectorCapability> getCapabilities() {
        return this.capabilities;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Integer getConnRequestTimeout() {
        return this.connRequestTimeout;
    }

    public void setConnRequestTimeout(Integer connRequestTimeout) {
        this.connRequestTimeout = connRequestTimeout;
    }

    public ConnPoolConfTO getPoolConf() {
        return this.poolConf;
    }

    public void setPoolConf(ConnPoolConfTO poolConf) {
        this.poolConf = poolConf;
    }
}

