/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.to;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.PathParam;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.syncope.common.lib.to.AbstractAnnotatedBean;
import org.apache.syncope.common.lib.to.ProvisionTO;
import org.apache.syncope.common.lib.types.ConnConfProperty;
import org.apache.syncope.common.lib.types.ConnectorCapability;
import org.apache.syncope.common.lib.types.TraceLevel;

@XmlRootElement(name="resource")
@XmlType
public class ResourceTO
extends AbstractAnnotatedBean {
    private static final long serialVersionUID = -9193551354041698963L;
    private String key;
    private Long connector;
    private String connectorDisplayName;
    private final List<ProvisionTO> provisions = new ArrayList<ProvisionTO>();
    private Integer propagationPriority;
    private boolean randomPwdIfNotProvided;
    private boolean enforceMandatoryCondition;
    private TraceLevel createTraceLevel = TraceLevel.ALL;
    private TraceLevel updateTraceLevel = TraceLevel.ALL;
    private TraceLevel deleteTraceLevel = TraceLevel.ALL;
    private TraceLevel syncTraceLevel = TraceLevel.ALL;
    private Long passwordPolicy;
    private Long accountPolicy;
    private Long syncPolicy;
    private final Set<ConnConfProperty> confOverride = new HashSet<ConnConfProperty>();
    private boolean overrideCapabilities = false;
    private final Set<ConnectorCapability> capabilitiesOverride = EnumSet.noneOf(ConnectorCapability.class);
    private final List<String> propagationActionsClassNames = new ArrayList<String>();

    public String getKey() {
        return this.key;
    }

    @PathParam(value="key")
    public void setKey(String key) {
        this.key = key;
    }

    public boolean isEnforceMandatoryCondition() {
        return this.enforceMandatoryCondition;
    }

    public void setEnforceMandatoryCondition(boolean enforceMandatoryCondition) {
        this.enforceMandatoryCondition = enforceMandatoryCondition;
    }

    public Long getConnector() {
        return this.connector;
    }

    public void setConnector(Long connector) {
        this.connector = connector;
    }

    public String getConnectorDisplayName() {
        return this.connectorDisplayName;
    }

    public void setConnectorDisplayName(String connectorDisplayName) {
        this.connectorDisplayName = connectorDisplayName;
    }

    public Integer getPropagationPriority() {
        return this.propagationPriority;
    }

    public void setPropagationPriority(Integer propagationPriority) {
        this.propagationPriority = propagationPriority;
    }

    public boolean isRandomPwdIfNotProvided() {
        return this.randomPwdIfNotProvided;
    }

    public void setRandomPwdIfNotProvided(boolean randomPwdIfNotProvided) {
        this.randomPwdIfNotProvided = randomPwdIfNotProvided;
    }

    public TraceLevel getCreateTraceLevel() {
        return this.createTraceLevel;
    }

    public void setCreateTraceLevel(TraceLevel createTraceLevel) {
        this.createTraceLevel = createTraceLevel;
    }

    public TraceLevel getDeleteTraceLevel() {
        return this.deleteTraceLevel;
    }

    public void setDeleteTraceLevel(TraceLevel deleteTraceLevel) {
        this.deleteTraceLevel = deleteTraceLevel;
    }

    public TraceLevel getUpdateTraceLevel() {
        return this.updateTraceLevel;
    }

    public void setUpdateTraceLevel(TraceLevel updateTraceLevel) {
        this.updateTraceLevel = updateTraceLevel;
    }

    public Long getPasswordPolicy() {
        return this.passwordPolicy;
    }

    public void setPasswordPolicy(Long passwordPolicy) {
        this.passwordPolicy = passwordPolicy;
    }

    public Long getAccountPolicy() {
        return this.accountPolicy;
    }

    public void setAccountPolicy(Long accountPolicy) {
        this.accountPolicy = accountPolicy;
    }

    public Long getSyncPolicy() {
        return this.syncPolicy;
    }

    public void setSyncPolicy(Long syncPolicy) {
        this.syncPolicy = syncPolicy;
    }

    @JsonIgnore
    public ProvisionTO getProvision(final String anyType) {
        return (ProvisionTO)IterableUtils.find(this.provisions, (Predicate)new Predicate<ProvisionTO>(){

            public boolean evaluate(ProvisionTO provisionTO) {
                return anyType != null && anyType.equals(provisionTO.getAnyType());
            }
        });
    }

    @XmlElementWrapper(name="provisions")
    @XmlElement(name="provision")
    @JsonProperty(value="provisions")
    public List<ProvisionTO> getProvisions() {
        return this.provisions;
    }

    @XmlElementWrapper(name="confOverride")
    @XmlElement(name="property")
    @JsonProperty(value="confOverride")
    public Set<ConnConfProperty> getConfOverride() {
        return this.confOverride;
    }

    public boolean isOverrideCapabilities() {
        return this.overrideCapabilities;
    }

    public void setOverrideCapabilities(boolean overrideCapabilities) {
        this.overrideCapabilities = overrideCapabilities;
    }

    @XmlElementWrapper(name="capabilitiesOverride")
    @XmlElement(name="capability")
    @JsonProperty(value="capabilitiesOverride")
    public Set<ConnectorCapability> getCapabilitiesOverride() {
        return this.capabilitiesOverride;
    }

    public TraceLevel getSyncTraceLevel() {
        return this.syncTraceLevel;
    }

    public void setSyncTraceLevel(TraceLevel syncTraceLevel) {
        this.syncTraceLevel = syncTraceLevel;
    }

    @XmlElementWrapper(name="propagationActionsClassNames")
    @XmlElement(name="propagationActionsClassName")
    @JsonProperty(value="propagationActionsClassNames")
    public List<String> getPropagationActionsClassNames() {
        return this.propagationActionsClassNames;
    }
}

