/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.to;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.RelationshipTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;

@XmlRootElement(name="user")
@XmlType
public class UserTO
extends AnyTO {
    private static final long serialVersionUID = 7791304495192615740L;
    private String password;
    private final List<String> roles = new ArrayList<String>();
    private final List<String> dynRoles = new ArrayList<String>();
    private String token;
    private Date tokenExpireTime;
    private String username;
    private Date lastLoginDate;
    private Date changePwdDate;
    private Integer failedLogins;
    private Long securityQuestion;
    private String securityAnswer;
    private boolean mustChangePassword;
    private final List<RelationshipTO> relationships = new ArrayList<RelationshipTO>();
    private final List<MembershipTO> memberships = new ArrayList<MembershipTO>();
    private final List<Long> dynGroups = new ArrayList<Long>();

    @Override
    public String getType() {
        return AnyTypeKind.USER.name();
    }

    @Override
    public void setType(String type) {
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @XmlElementWrapper(name="roles")
    @XmlElement(name="role")
    @JsonProperty(value="roles")
    public List<String> getRoles() {
        return this.roles;
    }

    @XmlElementWrapper(name="dynRoles")
    @XmlElement(name="role")
    @JsonProperty(value="dynRoles")
    public List<String> getDynRoles() {
        return this.dynRoles;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Date getTokenExpireTime() {
        return this.tokenExpireTime == null ? null : new Date(this.tokenExpireTime.getTime());
    }

    public void setTokenExpireTime(Date tokenExpireTime) {
        if (tokenExpireTime != null) {
            this.tokenExpireTime = new Date(tokenExpireTime.getTime());
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Date getChangePwdDate() {
        return this.changePwdDate;
    }

    public Integer getFailedLogins() {
        return this.failedLogins;
    }

    public Date getLastLoginDate() {
        return this.lastLoginDate;
    }

    public void setChangePwdDate(Date changePwdDate) {
        this.changePwdDate = changePwdDate;
    }

    public void setFailedLogins(Integer failedLogins) {
        this.failedLogins = failedLogins;
    }

    public void setLastLoginDate(Date lastLoginDate) {
        this.lastLoginDate = lastLoginDate;
    }

    public Long getSecurityQuestion() {
        return this.securityQuestion;
    }

    public void setSecurityQuestion(Long securityQuestion) {
        this.securityQuestion = securityQuestion;
    }

    public String getSecurityAnswer() {
        return this.securityAnswer;
    }

    public void setSecurityAnswer(String securityAnswer) {
        this.securityAnswer = securityAnswer;
    }

    public boolean isMustChangePassword() {
        return this.mustChangePassword;
    }

    public void setMustChangePassword(boolean mustChangePassword) {
        this.mustChangePassword = mustChangePassword;
    }

    @XmlElementWrapper(name="relationships")
    @XmlElement(name="relationship")
    @JsonProperty(value="relationships")
    public List<RelationshipTO> getRelationships() {
        return this.relationships;
    }

    @JsonIgnore
    public Map<Long, RelationshipTO> getRelationshipMap() {
        HashMap<Long, RelationshipTO> result = new HashMap(this.getRelationships().size());
        for (RelationshipTO membership : this.getRelationships()) {
            result.put(membership.getRightKey(), membership);
        }
        result = Collections.unmodifiableMap(result);
        return result;
    }

    @XmlElementWrapper(name="memberships")
    @XmlElement(name="membership")
    @JsonProperty(value="memberships")
    public List<MembershipTO> getMemberships() {
        return this.memberships;
    }

    @JsonIgnore
    public Map<Long, MembershipTO> getMembershipMap() {
        HashMap<Long, MembershipTO> result = new HashMap(this.getMemberships().size());
        for (MembershipTO membership : this.getMemberships()) {
            result.put(membership.getRightKey(), membership);
        }
        result = Collections.unmodifiableMap(result);
        return result;
    }

    @XmlElementWrapper(name="dynGroups")
    @XmlElement(name="role")
    @JsonProperty(value="dynGroups")
    public List<Long> getDynGroups() {
        return this.dynGroups;
    }

    @Override
    public String toString() {
        return new ReflectionToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE){

            protected boolean accept(Field f) {
                return super.accept(f) && !f.getName().equals("password");
            }
        }.toString();
    }
}

