/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.types;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlEnum;
import org.apache.syncope.common.lib.types.AnyTypeKind;

@XmlEnum
public enum IntMappingType {
    UserPlainSchema(AnyTypeKind.USER),
    UserDerivedSchema(AnyTypeKind.USER),
    UserVirtualSchema(AnyTypeKind.USER),
    UserKey(AnyTypeKind.USER),
    Username(AnyTypeKind.USER),
    Password(AnyTypeKind.USER),
    GroupPlainSchema(AnyTypeKind.GROUP),
    GroupDerivedSchema(AnyTypeKind.GROUP),
    GroupVirtualSchema(AnyTypeKind.GROUP),
    GroupKey(AnyTypeKind.GROUP),
    GroupName(AnyTypeKind.GROUP),
    GroupOwnerSchema(AnyTypeKind.GROUP),
    AnyObjectPlainSchema(AnyTypeKind.ANY_OBJECT),
    AnyObjectDerivedSchema(AnyTypeKind.ANY_OBJECT),
    AnyObjectVirtualSchema(AnyTypeKind.ANY_OBJECT),
    AnyObjectKey(AnyTypeKind.ANY_OBJECT);

    private final AnyTypeKind anyTypeKind;

    private IntMappingType(AnyTypeKind anyTypeKind) {
        this.anyTypeKind = anyTypeKind;
    }

    public AnyTypeKind getAnyTypeKind() {
        return this.anyTypeKind;
    }

    public static Set<IntMappingType> getAttributeTypes(AnyTypeKind anyTypeKind, Collection<IntMappingType> toBeFiltered) {
        Set<IntMappingType> res = IntMappingType.getAttributeTypes(anyTypeKind);
        res.removeAll(toBeFiltered);
        return res;
    }

    public static Set<IntMappingType> getAttributeTypes(AnyTypeKind anyTypeKind) {
        EnumSet<Enum> enumset;
        switch (anyTypeKind) {
            case GROUP: {
                enumset = EnumSet.allOf(GroupMappingType.class);
                break;
            }
            case ANY_OBJECT: {
                enumset = EnumSet.allOf(AnyMappingType.class);
                break;
            }
            default: {
                enumset = EnumSet.allOf(UserMappingType.class);
            }
        }
        HashSet<IntMappingType> result = new HashSet<IntMappingType>(enumset.size());
        for (Object e : enumset) {
            result.add(IntMappingType.valueOf(e.toString()));
        }
        return result;
    }

    public static Set<IntMappingType> getEmbedded() {
        return EnumSet.of(UserKey, new IntMappingType[]{Username, Password, GroupKey, GroupName, GroupOwnerSchema, AnyObjectKey});
    }

    public static boolean contains(AnyTypeKind anyTypeKind, String type) {
        switch (anyTypeKind) {
            case GROUP: {
                for (GroupMappingType c : GroupMappingType.values()) {
                    if (!c.name().equals(type)) continue;
                    return true;
                }
                break;
            }
            case ANY_OBJECT: {
                for (AnyMappingType c : AnyMappingType.values()) {
                    if (!c.name().equals(type)) continue;
                    return true;
                }
                break;
            }
            default: {
                for (UserMappingType c : UserMappingType.values()) {
                    if (!c.name().equals(type)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static enum AnyMappingType {
        AnyObjectPlainSchema,
        AnyObjectDerivedSchema,
        AnyObjectVirtualSchema,
        AnyObjectKey;

    }

    private static enum GroupMappingType {
        GroupPlainSchema,
        GroupDerivedSchema,
        GroupVirtualSchema,
        GroupKey,
        GroupName,
        GroupOwnerSchema;

    }

    private static enum UserMappingType {
        UserPlainSchema,
        UserDerivedSchema,
        UserVirtualSchema,
        UserKey,
        Username,
        Password;

    }
}

