/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.types;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.syncope.common.lib.types.ResourceOperation;

public class PropagationByResource
implements Serializable {
    private static final long serialVersionUID = -5699740428104336636L;
    private final Set<String> toBeCreated = new HashSet<String>();
    private final Set<String> toBeUpdated = new HashSet<String>();
    private final Set<String> toBeDeleted = new HashSet<String>();
    private final Map<String, String> oldConnObjectKeys = new HashMap<String, String>();

    public final void purge() {
        this.toBeCreated.removeAll(this.toBeDeleted);
        this.toBeCreated.removeAll(this.toBeUpdated);
        this.toBeUpdated.removeAll(this.toBeDeleted);
    }

    public final boolean add(ResourceOperation type, String resourceName) {
        Set<String> set;
        switch (type) {
            case CREATE: {
                set = this.toBeCreated;
                break;
            }
            case UPDATE: {
                set = this.toBeUpdated;
                break;
            }
            default: {
                set = this.toBeDeleted;
            }
        }
        return set.add(resourceName);
    }

    public boolean addAll(ResourceOperation type, Collection<String> resourceNames) {
        Set<String> set;
        switch (type) {
            case CREATE: {
                set = this.toBeCreated;
                break;
            }
            case UPDATE: {
                set = this.toBeUpdated;
                break;
            }
            default: {
                set = this.toBeDeleted;
            }
        }
        return set.addAll(resourceNames);
    }

    public final boolean remove(ResourceOperation type, String resourceName) {
        boolean result = false;
        switch (type) {
            case CREATE: {
                result = this.toBeCreated.remove(resourceName);
                break;
            }
            case UPDATE: {
                result = this.toBeUpdated.remove(resourceName);
                break;
            }
            case DELETE: {
                result = this.toBeDeleted.remove(resourceName);
                break;
            }
        }
        return result;
    }

    public boolean removeAll(ResourceOperation type, Set<String> resourceNames) {
        Set<String> set;
        switch (type) {
            case CREATE: {
                set = this.toBeCreated;
                break;
            }
            case UPDATE: {
                set = this.toBeUpdated;
                break;
            }
            default: {
                set = this.toBeDeleted;
            }
        }
        return set.removeAll(resourceNames);
    }

    public boolean removeAll(Collection<String> resourceNames) {
        return this.toBeCreated.removeAll(resourceNames) | this.toBeUpdated.removeAll(resourceNames) | this.toBeDeleted.removeAll(resourceNames);
    }

    public boolean retainAll(Collection<String> resourceNames) {
        return this.toBeCreated.retainAll(resourceNames) | this.toBeUpdated.retainAll(resourceNames) | this.toBeDeleted.retainAll(resourceNames);
    }

    public boolean contains(ResourceOperation type, String resourceName) {
        boolean result = false;
        switch (type) {
            case CREATE: {
                result = this.toBeCreated.contains(resourceName);
                break;
            }
            case UPDATE: {
                result = this.toBeUpdated.contains(resourceName);
                break;
            }
            case DELETE: {
                result = this.toBeDeleted.contains(resourceName);
                break;
            }
        }
        return result;
    }

    public final Set<String> get(ResourceOperation type) {
        Set<String> result = Collections.emptySet();
        switch (type) {
            case CREATE: {
                result = this.toBeCreated;
                break;
            }
            case UPDATE: {
                result = this.toBeUpdated;
                break;
            }
            case DELETE: {
                result = this.toBeDeleted;
                break;
            }
        }
        return result;
    }

    public Map<String, ResourceOperation> asMap() {
        HashMap<String, ResourceOperation> result = new HashMap<String, ResourceOperation>();
        for (ResourceOperation operation : ResourceOperation.values()) {
            for (String resourceName : this.get(operation)) {
                result.put(resourceName, operation);
            }
        }
        return result;
    }

    public final void set(ResourceOperation type, Collection<String> resourceNames) {
        switch (type) {
            case CREATE: {
                this.toBeCreated.clear();
                this.toBeCreated.addAll(resourceNames);
                break;
            }
            case UPDATE: {
                this.toBeUpdated.clear();
                this.toBeUpdated.addAll(resourceNames);
                break;
            }
            case DELETE: {
                this.toBeDeleted.clear();
                this.toBeDeleted.addAll(resourceNames);
                break;
            }
        }
    }

    public final void merge(PropagationByResource propByRes) {
        if (propByRes != null) {
            this.toBeCreated.addAll(propByRes.get(ResourceOperation.CREATE));
            this.toBeUpdated.addAll(propByRes.get(ResourceOperation.UPDATE));
            this.toBeDeleted.addAll(propByRes.get(ResourceOperation.DELETE));
            this.oldConnObjectKeys.putAll(propByRes.getOldConnObjectKeys());
        }
    }

    public void clear() {
        this.toBeCreated.clear();
        this.toBeUpdated.clear();
        this.toBeDeleted.clear();
    }

    public final boolean isEmpty() {
        return this.toBeCreated.isEmpty() && this.toBeUpdated.isEmpty() && this.toBeDeleted.isEmpty() && this.oldConnObjectKeys.isEmpty();
    }

    public Map<String, String> getOldConnObjectKeys() {
        return this.oldConnObjectKeys;
    }

    public String getOldConnObjectKey(String resourceName) {
        return this.oldConnObjectKeys.get(resourceName);
    }

    public void addOldConnObjectKey(String resourceName, String oldConnObjectKey) {
        if (resourceName != null && oldConnObjectKey != null) {
            this.oldConnObjectKeys.put(resourceName, oldConnObjectKey);
        }
    }

    public String toString() {
        return "To be Created: " + this.toBeCreated + ";\n" + "To be Updated: " + this.toBeUpdated + ";\n" + "To be Deleted: " + this.toBeDeleted + ";\n" + "Old connObjectKeys: " + this.oldConnObjectKeys;
    }
}

