/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.to;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.GroupableRelatableTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.RelationshipTO;

@XmlRootElement(name="anyObject")
@XmlType
public class AnyObjectTO
extends AnyTO
implements GroupableRelatableTO {
    private static final long serialVersionUID = 8841697496476959639L;
    private String name;
    private final List<RelationshipTO> relationships = new ArrayList<RelationshipTO>();
    private final List<MembershipTO> memberships = new ArrayList<MembershipTO>();
    private final List<String> dynGroups = new ArrayList<String>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    @XmlElementWrapper(name="relationships")
    @XmlElement(name="relationship")
    @JsonProperty(value="relationships")
    public List<RelationshipTO> getRelationships() {
        return this.relationships;
    }

    @Override
    @JsonIgnore
    public Map<Pair<String, String>, RelationshipTO> getRelationshipMap() {
        HashMap<Pair<String, String>, RelationshipTO> result = new HashMap(this.getRelationships().size());
        for (RelationshipTO relationship : this.getRelationships()) {
            result.put((Pair<String, String>)Pair.of((Object)relationship.getType(), (Object)relationship.getRightKey()), relationship);
        }
        result = Collections.unmodifiableMap(result);
        return result;
    }

    @Override
    @XmlElementWrapper(name="memberships")
    @XmlElement(name="membership")
    @JsonProperty(value="memberships")
    public List<MembershipTO> getMemberships() {
        return this.memberships;
    }

    @Override
    @JsonIgnore
    public Map<String, MembershipTO> getMembershipMap() {
        HashMap<String, MembershipTO> result = new HashMap(this.getMemberships().size());
        for (MembershipTO membership : this.getMemberships()) {
            result.put(membership.getRightKey(), membership);
        }
        result = Collections.unmodifiableMap(result);
        return result;
    }

    @Override
    @XmlElementWrapper(name="dynGroups")
    @XmlElement(name="role")
    @JsonProperty(value="dynGroups")
    public List<String> getDynGroups() {
        return this.dynGroups;
    }
}

