/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.to;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.syncope.common.lib.AbstractBaseBean;
import org.apache.syncope.common.lib.to.MappingItemTO;

@XmlRootElement(name="mapping")
@XmlType
public class MappingTO
extends AbstractBaseBean {
    private static final long serialVersionUID = 8447688036282611118L;
    private String connObjectLink;
    private final List<MappingItemTO> items = new ArrayList<MappingItemTO>();
    private final List<MappingItemTO> linkingItems = new ArrayList<MappingItemTO>();

    public String getConnObjectLink() {
        return this.connObjectLink;
    }

    public void setConnObjectLink(String connObjectLink) {
        this.connObjectLink = connObjectLink;
    }

    public MappingItemTO getConnObjectKeyItem() {
        return (MappingItemTO)IterableUtils.find(this.getItems(), (Predicate)new Predicate<MappingItemTO>(){

            public boolean evaluate(MappingItemTO item) {
                return item.isConnObjectKey();
            }
        });
    }

    protected boolean addConnObjectKeyItem(MappingItemTO connObjectItem) {
        connObjectItem.setMandatoryCondition("true");
        connObjectItem.setConnObjectKey(true);
        return this.add(connObjectItem);
    }

    public boolean setConnObjectKeyItem(MappingItemTO connObjectKeyItem) {
        return connObjectKeyItem == null ? this.remove(this.getConnObjectKeyItem()) : this.addConnObjectKeyItem(connObjectKeyItem);
    }

    @XmlElementWrapper(name="items")
    @XmlElement(name="item")
    @JsonProperty(value="items")
    public List<MappingItemTO> getItems() {
        return this.items;
    }

    public boolean add(MappingItemTO item) {
        return item == null ? false : this.items.contains(item) || this.items.add(item);
    }

    public boolean remove(MappingItemTO item) {
        return this.items.remove(item);
    }

    @XmlElementWrapper(name="linkingItems")
    @XmlElement(name="item")
    @JsonProperty(value="linkingItems")
    public List<MappingItemTO> getLinkingItems() {
        return this.linkingItems;
    }
}

