/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.to;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.AttributableTO;
import org.apache.syncope.common.lib.to.RelationshipTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;

@XmlRootElement(name="membership")
@XmlType
public class MembershipTO
extends RelationshipTO
implements AttributableTO {
    private static final long serialVersionUID = 5992828670273935861L;
    private String groupName;
    private final Set<AttrTO> plainAttrs = new HashSet<AttrTO>();
    private final Set<AttrTO> derAttrs = new HashSet<AttrTO>();
    private final Set<AttrTO> virAttrs = new HashSet<AttrTO>();

    @Override
    public String getType() {
        return "Membership";
    }

    @Override
    public void setType(String relationshipType) {
    }

    @Override
    public String getRightType() {
        return AnyTypeKind.GROUP.name();
    }

    @Override
    public void setRightType(String rightType) {
    }

    @JsonIgnore
    public String getGroupKey() {
        return this.getRightKey();
    }

    public void setGroupKey(String groupKey) {
        this.setRightKey(groupKey);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    @Override
    public Set<AttrTO> getPlainAttrs() {
        return this.plainAttrs;
    }

    @Override
    public Map<String, AttrTO> getPlainAttrMap() {
        HashMap<String, AttrTO> result = new HashMap<String, AttrTO>(this.plainAttrs.size());
        for (AttrTO attributeTO : this.plainAttrs) {
            result.put(attributeTO.getSchema(), attributeTO);
        }
        return Collections.unmodifiableMap(result);
    }

    @Override
    public Set<AttrTO> getDerAttrs() {
        return this.derAttrs;
    }

    @Override
    public Map<String, AttrTO> getDerAttrMap() {
        HashMap<String, AttrTO> result = new HashMap<String, AttrTO>(this.derAttrs.size());
        for (AttrTO attributeTO : this.derAttrs) {
            result.put(attributeTO.getSchema(), attributeTO);
        }
        return Collections.unmodifiableMap(result);
    }

    @Override
    public Set<AttrTO> getVirAttrs() {
        return this.virAttrs;
    }

    @Override
    public Map<String, AttrTO> getVirAttrMap() {
        HashMap<String, AttrTO> result = new HashMap<String, AttrTO>(this.virAttrs.size());
        for (AttrTO attributeTO : this.virAttrs) {
            result.put(attributeTO.getSchema(), attributeTO);
        }
        return Collections.unmodifiableMap(result);
    }

    public static class Builder {
        private final MembershipTO instance = new MembershipTO();

        public Builder group(String groupKey) {
            this.instance.setRightKey(groupKey);
            return this;
        }

        public Builder group(String groupKey, String groupName) {
            this.instance.setRightKey(groupKey);
            this.instance.setGroupName(groupName);
            return this;
        }

        public MembershipTO build() {
            return this.instance;
        }
    }
}

