/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.types;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.syncope.common.lib.types.ResourceOperation;

public class PropagationByResource
implements Serializable {
    private static final long serialVersionUID = -5699740428104336636L;
    private final Set<String> toBeCreated = new HashSet<String>();
    private final Set<String> toBeUpdated = new HashSet<String>();
    private final Set<String> toBeDeleted = new HashSet<String>();
    private final Map<String, String> oldConnObjectKeys = new HashMap<String, String>();

    public final void purge() {
        this.toBeCreated.removeAll(this.toBeDeleted);
        this.toBeCreated.removeAll(this.toBeUpdated);
        this.toBeUpdated.removeAll(this.toBeDeleted);
    }

    public final boolean add(ResourceOperation type, String resourceKey) {
        Set<String> set;
        switch (type) {
            case CREATE: {
                set = this.toBeCreated;
                break;
            }
            case UPDATE: {
                set = this.toBeUpdated;
                break;
            }
            default: {
                set = this.toBeDeleted;
            }
        }
        return set.add(resourceKey);
    }

    public boolean addAll(ResourceOperation type, Collection<String> resourceKeys) {
        Set<String> set;
        switch (type) {
            case CREATE: {
                set = this.toBeCreated;
                break;
            }
            case UPDATE: {
                set = this.toBeUpdated;
                break;
            }
            default: {
                set = this.toBeDeleted;
            }
        }
        return set.addAll(resourceKeys);
    }

    public final boolean remove(ResourceOperation type, String resourceKey) {
        boolean result = false;
        switch (type) {
            case CREATE: {
                result = this.toBeCreated.remove(resourceKey);
                break;
            }
            case UPDATE: {
                result = this.toBeUpdated.remove(resourceKey);
                break;
            }
            case DELETE: {
                result = this.toBeDeleted.remove(resourceKey);
                break;
            }
        }
        return result;
    }

    public boolean removeAll(ResourceOperation type, Set<String> resourceKeys) {
        Set<String> set;
        switch (type) {
            case CREATE: {
                set = this.toBeCreated;
                break;
            }
            case UPDATE: {
                set = this.toBeUpdated;
                break;
            }
            default: {
                set = this.toBeDeleted;
            }
        }
        return set.removeAll(resourceKeys);
    }

    public boolean removeAll(Collection<String> resourceKeys) {
        return this.toBeCreated.removeAll(resourceKeys) | this.toBeUpdated.removeAll(resourceKeys) | this.toBeDeleted.removeAll(resourceKeys);
    }

    public boolean retainAll(Collection<String> resourceKeys) {
        return this.toBeCreated.retainAll(resourceKeys) | this.toBeUpdated.retainAll(resourceKeys) | this.toBeDeleted.retainAll(resourceKeys);
    }

    public boolean contains(ResourceOperation type, String resourceKey) {
        boolean result = false;
        switch (type) {
            case CREATE: {
                result = this.toBeCreated.contains(resourceKey);
                break;
            }
            case UPDATE: {
                result = this.toBeUpdated.contains(resourceKey);
                break;
            }
            case DELETE: {
                result = this.toBeDeleted.contains(resourceKey);
                break;
            }
        }
        return result;
    }

    public final Set<String> get(ResourceOperation type) {
        Set<String> result = Collections.emptySet();
        switch (type) {
            case CREATE: {
                result = this.toBeCreated;
                break;
            }
            case UPDATE: {
                result = this.toBeUpdated;
                break;
            }
            case DELETE: {
                result = this.toBeDeleted;
                break;
            }
        }
        return result;
    }

    public Map<String, ResourceOperation> asMap() {
        HashMap<String, ResourceOperation> result = new HashMap<String, ResourceOperation>();
        for (ResourceOperation operation : ResourceOperation.values()) {
            for (String resourceKey : this.get(operation)) {
                result.put(resourceKey, operation);
            }
        }
        return result;
    }

    public final void set(ResourceOperation type, Collection<String> resourceKeys) {
        switch (type) {
            case CREATE: {
                this.toBeCreated.clear();
                this.toBeCreated.addAll(resourceKeys);
                break;
            }
            case UPDATE: {
                this.toBeUpdated.clear();
                this.toBeUpdated.addAll(resourceKeys);
                break;
            }
            case DELETE: {
                this.toBeDeleted.clear();
                this.toBeDeleted.addAll(resourceKeys);
                break;
            }
        }
    }

    public final void merge(PropagationByResource propByRes) {
        if (propByRes != null) {
            this.toBeCreated.addAll(propByRes.get(ResourceOperation.CREATE));
            this.toBeUpdated.addAll(propByRes.get(ResourceOperation.UPDATE));
            this.toBeDeleted.addAll(propByRes.get(ResourceOperation.DELETE));
            this.oldConnObjectKeys.putAll(propByRes.getOldConnObjectKeys());
        }
    }

    public void clear() {
        this.toBeCreated.clear();
        this.toBeUpdated.clear();
        this.toBeDeleted.clear();
    }

    public final boolean isEmpty() {
        return this.toBeCreated.isEmpty() && this.toBeUpdated.isEmpty() && this.toBeDeleted.isEmpty() && this.oldConnObjectKeys.isEmpty();
    }

    public Map<String, String> getOldConnObjectKeys() {
        return this.oldConnObjectKeys;
    }

    public String getOldConnObjectKey(String resourceKey) {
        return this.oldConnObjectKeys.get(resourceKey);
    }

    public void addOldConnObjectKey(String resourceKey, String oldConnObjectKey) {
        if (resourceKey != null && oldConnObjectKey != null) {
            this.oldConnObjectKeys.put(resourceKey, oldConnObjectKey);
        }
    }

    public String toString() {
        return "To be Created: " + this.toBeCreated + ";\n" + "To be Updated: " + this.toBeUpdated + ";\n" + "To be Deleted: " + this.toBeDeleted + ";\n" + "Old connObjectKeys: " + this.oldConnObjectKeys;
    }
}

