/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang3.tuple.Pair;

public final class PropertyUtils {
    public static Pair<Properties, String> read(Class<?> clazz, String propertiesFileName, String confDirProp) {
        Properties props = new Properties();
        String confDirName = null;
        try (InputStream is = clazz.getResourceAsStream("/" + propertiesFileName);){
            File confDirProps;
            File confDir;
            props.load(is);
            confDirName = props.getProperty(confDirProp);
            if (confDirName != null && (confDir = new File(confDirName)).exists() && confDir.canRead() && confDir.isDirectory() && (confDirProps = new File(confDir, propertiesFileName)).exists() && confDirProps.canRead() && confDirProps.isFile()) {
                props.clear();
                props.load(new FileInputStream(confDirProps));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not read " + propertiesFileName, e);
        }
        return Pair.of((Object)props, (Object)confDirName);
    }

    private PropertyUtils() {
    }
}

