/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.search;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;

public final class SearchableFields {
    private static final String[] ATTRIBUTES_NOTINCLUDED = new String[]{"serialVersionUID", "password", "type", "udynMembershipCond"};
    private static final Set<String> ANY_FIELDS = new HashSet<String>();

    public static boolean contains(String schema) {
        return ANY_FIELDS.contains(schema);
    }

    public static List<String> get(AnyTypeKind anyTypeKind) {
        return SearchableFields.get(anyTypeKind.getTOClass());
    }

    public static List<String> get(Class<? extends AnyTO> anyRef) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (Class<? extends AnyTO> clazz = anyRef; clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                if (ArrayUtils.contains((Object[])ATTRIBUTES_NOTINCLUDED, (Object)field.getName()) || Collection.class.isAssignableFrom(field.getType()) || Map.class.isAssignableFrom(field.getType())) continue;
                fieldNames.add(field.getName());
            }
        }
        Collections.reverse(fieldNames);
        return fieldNames;
    }

    private SearchableFields() {
    }

    static {
        ANY_FIELDS.addAll(SearchableFields.get(UserTO.class));
        ANY_FIELDS.addAll(SearchableFields.get(GroupTO.class));
        ANY_FIELDS.addAll(SearchableFields.get(AnyObjectTO.class));
    }
}

