/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.to;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.AttributableTO;
import org.apache.syncope.common.lib.to.RelationshipTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;

@XmlRootElement(name="membership")
@XmlType
public class MembershipTO
extends RelationshipTO
implements AttributableTO {
    private static final long serialVersionUID = 5992828670273935861L;
    private String groupName;
    private final Set<AttrTO> plainAttrs = new HashSet<AttrTO>();
    private final Set<AttrTO> derAttrs = new HashSet<AttrTO>();
    private final Set<AttrTO> virAttrs = new HashSet<AttrTO>();

    @Override
    public String getType() {
        return "Membership";
    }

    @Override
    public void setType(String relationshipType) {
    }

    @Override
    public String getRightType() {
        return AnyTypeKind.GROUP.name();
    }

    @Override
    public void setRightType(String rightType) {
    }

    @JsonIgnore
    public String getGroupKey() {
        return this.getRightKey();
    }

    public void setGroupKey(String groupKey) {
        this.setRightKey(groupKey);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    @Override
    @XmlElementWrapper(name="plainAttrs")
    @XmlElement(name="attribute")
    @JsonProperty(value="plainAttrs")
    public Set<AttrTO> getPlainAttrs() {
        return this.plainAttrs;
    }

    @Override
    @JsonIgnore
    public AttrTO getPlainAttr(final String schema) {
        return (AttrTO)IterableUtils.find(this.plainAttrs, (Predicate)new Predicate<AttrTO>(){

            public boolean evaluate(AttrTO object) {
                return object.getSchema().equals(schema);
            }
        });
    }

    @Override
    @XmlElementWrapper(name="derAttrs")
    @XmlElement(name="attribute")
    @JsonProperty(value="derAttrs")
    public Set<AttrTO> getDerAttrs() {
        return this.derAttrs;
    }

    @Override
    @JsonIgnore
    public AttrTO getDerAttr(final String schema) {
        return (AttrTO)IterableUtils.find(this.derAttrs, (Predicate)new Predicate<AttrTO>(){

            public boolean evaluate(AttrTO object) {
                return object.getSchema().equals(schema);
            }
        });
    }

    @Override
    @XmlElementWrapper(name="virAttrs")
    @XmlElement(name="attribute")
    @JsonProperty(value="virAttrs")
    public Set<AttrTO> getVirAttrs() {
        return this.virAttrs;
    }

    @Override
    @JsonIgnore
    public AttrTO getVirAttr(final String schema) {
        return (AttrTO)IterableUtils.find(this.virAttrs, (Predicate)new Predicate<AttrTO>(){

            public boolean evaluate(AttrTO object) {
                return object.getSchema().equals(schema);
            }
        });
    }

    public static class Builder {
        private final MembershipTO instance = new MembershipTO();

        public Builder group(String groupKey) {
            this.instance.setRightKey(groupKey);
            return this;
        }

        public Builder group(String groupKey, String groupName) {
            this.instance.setRightKey(groupKey);
            this.instance.setGroupName(groupName);
            return this;
        }

        public MembershipTO build() {
            return this.instance;
        }
    }
}

