/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service;

import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.syncope.common.lib.to.BulkActionResult;
import org.apache.syncope.common.lib.to.ReportExecTO;
import org.apache.syncope.common.lib.to.ReportTO;
import org.apache.syncope.common.lib.types.JobAction;
import org.apache.syncope.common.lib.types.JobStatusType;
import org.apache.syncope.common.lib.types.ReportExecExportFormat;
import org.apache.syncope.common.rest.api.beans.BulkExecDeleteQuery;
import org.apache.syncope.common.rest.api.beans.ExecuteQuery;
import org.apache.syncope.common.rest.api.service.JAXRSService;

@Path(value="reports")
public interface ReportService
extends JAXRSService {
    @GET
    @Path(value="{key}")
    @Produces(value={"application/xml;qs=0.9", "application/json"})
    public ReportTO read(@NotNull @PathParam(value="key") Long var1);

    @GET
    @Produces(value={"application/xml;qs=0.9", "application/json"})
    public List<ReportTO> list();

    @POST
    @Consumes(value={"application/xml;qs=0.9", "application/json"})
    public Response create(@NotNull ReportTO var1);

    @PUT
    @Path(value="{key}")
    @Consumes(value={"application/xml;qs=0.9", "application/json"})
    public void update(@NotNull ReportTO var1);

    @DELETE
    @Path(value="{key}")
    public void delete(@NotNull @PathParam(value="key") Long var1);

    @DELETE
    @Path(value="executions/{executionKey}")
    public void deleteExecution(@NotNull @PathParam(value="executionKey") Long var1);

    @DELETE
    @Path(value="{key}/executions")
    @Produces(value={"application/xml", "application/json"})
    public BulkActionResult deleteExecutions(@BeanParam BulkExecDeleteQuery var1);

    @POST
    @Path(value="{key}/execute")
    @Produces(value={"application/xml;qs=0.9", "application/json"})
    public ReportExecTO execute(@BeanParam ExecuteQuery var1);

    @GET
    @Path(value="executions/{executionKey}/stream")
    @Consumes(value={"application/xml;qs=0.9", "application/json"})
    public Response exportExecutionResult(@NotNull @PathParam(value="executionKey") Long var1, @QueryParam(value="format") ReportExecExportFormat var2);

    @GET
    @Path(value="jobs")
    @Produces(value={"application/xml;qs=0.9", "application/json"})
    public List<ReportExecTO> listJobs(@MatrixParam(value="type") JobStatusType var1);

    @POST
    @Path(value="{key}")
    public void actionJob(@PathParam(value="key") Long var1, @QueryParam(value="action") JobAction var2);
}

