/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service;

import java.util.List;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BeanParam;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.syncope.common.lib.to.BulkActionResult;
import org.apache.syncope.common.lib.to.ExecTO;
import org.apache.syncope.common.lib.to.JobTO;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.lib.types.JobAction;
import org.apache.syncope.common.rest.api.beans.BulkExecDeleteQuery;
import org.apache.syncope.common.rest.api.beans.ExecQuery;
import org.apache.syncope.common.rest.api.beans.ExecuteQuery;
import org.apache.syncope.common.rest.api.service.JAXRSService;

public interface ExecutableService
extends JAXRSService {
    @GET
    @Path(value="{key}/executions")
    @Produces(value={"application/json", "application/xml"})
    public PagedResult<ExecTO> listExecutions(@BeanParam ExecQuery var1);

    @GET
    @Path(value="executions/recent")
    @Produces(value={"application/json", "application/xml"})
    public List<ExecTO> listRecentExecutions(@Min(value=1L) @QueryParam(value="max") @DefaultValue(value="25") int var1);

    @DELETE
    @Path(value="executions/{executionKey}")
    public void deleteExecution(@NotNull @PathParam(value="executionKey") String var1);

    @DELETE
    @Path(value="{key}/executions")
    @Produces(value={"application/xml", "application/json"})
    public BulkActionResult deleteExecutions(@BeanParam BulkExecDeleteQuery var1);

    @POST
    @Path(value="{key}/execute")
    @Produces(value={"application/json", "application/xml"})
    public ExecTO execute(@BeanParam ExecuteQuery var1);

    @GET
    @Path(value="jobs")
    @Produces(value={"application/json", "application/xml"})
    public List<JobTO> listJobs();

    @POST
    @Path(value="jobs/{key}")
    public void actionJob(@NotNull @PathParam(value="key") String var1, @QueryParam(value="action") JobAction var2);
}

