/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service;

import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.syncope.common.lib.to.BulkAction;
import org.apache.syncope.common.lib.to.BulkActionResult;
import org.apache.syncope.common.lib.to.ConnBundleTO;
import org.apache.syncope.common.lib.to.ConnIdObjectClassTO;
import org.apache.syncope.common.lib.to.ConnInstanceTO;
import org.apache.syncope.common.rest.api.service.JAXRSService;

@Path(value="connectors")
public interface ConnectorService
extends JAXRSService {
    @GET
    @Path(value="bundles")
    @Produces(value={"application/json", "application/xml"})
    public List<ConnBundleTO> getBundles(@QueryParam(value="lang") String var1);

    @POST
    @Path(value="{key}/supportedObjectClasses")
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/json", "application/xml"})
    public List<ConnIdObjectClassTO> buildObjectClassInfo(@NotNull ConnInstanceTO var1, @QueryParam(value="includeSpecial") @DefaultValue(value="false") boolean var2);

    @GET
    @Path(value="{key}")
    @Produces(value={"application/json", "application/xml"})
    public ConnInstanceTO read(@NotNull @PathParam(value="key") String var1, @QueryParam(value="lang") String var2);

    @GET
    @Path(value="byResource/{resourceName}")
    @Produces(value={"application/json", "application/xml"})
    public ConnInstanceTO readByResource(@NotNull @PathParam(value="resourceName") String var1, @QueryParam(value="lang") String var2);

    @GET
    @Produces(value={"application/json", "application/xml"})
    public List<ConnInstanceTO> list(@QueryParam(value="lang") String var1);

    @POST
    @Consumes(value={"application/json", "application/xml"})
    public Response create(@NotNull ConnInstanceTO var1);

    @PUT
    @Path(value="{key}")
    @Consumes(value={"application/json", "application/xml"})
    public void update(@NotNull ConnInstanceTO var1);

    @DELETE
    @Path(value="{key}")
    public void delete(@NotNull @PathParam(value="key") String var1);

    @POST
    @Path(value="check")
    @Consumes(value={"application/json", "application/xml"})
    public void check(@NotNull ConnInstanceTO var1);

    @POST
    @Path(value="reload")
    public void reload();

    @POST
    @Path(value="bulk")
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/json", "application/xml"})
    public BulkActionResult bulk(@NotNull BulkAction var1);
}

