/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service;

import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.syncope.common.lib.patch.ResourceDeassociationPatch;
import org.apache.syncope.common.lib.to.BulkAction;
import org.apache.syncope.common.lib.to.BulkActionResult;
import org.apache.syncope.common.lib.to.ConnObjectTO;
import org.apache.syncope.common.lib.to.PagedConnObjectTOResult;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.syncope.common.rest.api.beans.ConnObjectTOListQuery;
import org.apache.syncope.common.rest.api.service.JAXRSService;

@Path(value="resources")
public interface ResourceService
extends JAXRSService {
    @GET
    @Path(value="{key}/{anyTypeKey}/{anyKey}")
    @Produces(value={"application/json", "application/xml"})
    public ConnObjectTO readConnObject(@NotNull @PathParam(value="key") String var1, @NotNull @PathParam(value="anyTypeKey") String var2, @NotNull @PathParam(value="anyKey") String var3);

    @GET
    @Path(value="{key}/{anyTypeKey}")
    @Produces(value={"application/json", "application/xml"})
    public PagedConnObjectTOResult listConnObjects(@NotNull @PathParam(value="key") String var1, @NotNull @PathParam(value="anyTypeKey") String var2, @BeanParam ConnObjectTOListQuery var3);

    @GET
    @Path(value="{key}")
    @Produces(value={"application/json", "application/xml"})
    public ResourceTO read(@NotNull @PathParam(value="key") String var1);

    @GET
    @Produces(value={"application/json", "application/xml"})
    public List<ResourceTO> list();

    @POST
    @Consumes(value={"application/json", "application/xml"})
    public Response create(@NotNull ResourceTO var1);

    @PUT
    @Path(value="{key}")
    @Consumes(value={"application/json", "application/xml"})
    public void update(@NotNull ResourceTO var1);

    @POST
    @Path(value="{key}/{anyTypeKey}")
    public void setLatestSyncToken(@NotNull @PathParam(value="key") String var1, @NotNull @PathParam(value="anyTypeKey") String var2);

    @DELETE
    @Path(value="{key}/{anyTypeKey}")
    public void removeSyncToken(@NotNull @PathParam(value="key") String var1, @NotNull @PathParam(value="anyTypeKey") String var2);

    @DELETE
    @Path(value="{key}")
    @Consumes(value={"application/json", "application/xml"})
    public void delete(@NotNull @PathParam(value="key") String var1);

    @POST
    @Path(value="check")
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/json", "application/xml"})
    public void check(@NotNull ResourceTO var1);

    @POST
    @Path(value="{key}/bulkDeassociation/{anyTypeKey}/{action}")
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/json", "application/xml"})
    public BulkActionResult bulkDeassociation(@NotNull ResourceDeassociationPatch var1);

    @POST
    @Path(value="bulk")
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/json", "application/xml"})
    public BulkActionResult bulk(@NotNull BulkAction var1);
}

