/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Future;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.api.ConnectorFacade;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.identityconnectors.framework.common.objects.Uid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Component;

@Component
public class AsyncConnectorFacade {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncConnectorFacade.class);

    @Async
    public Future<Uid> authenticate(ConnectorFacade connector, String username, GuardedString password, OperationOptions options) {
        return new AsyncResult((Object)connector.authenticate(ObjectClass.ACCOUNT, username, password, options));
    }

    @Async
    public Future<Uid> create(ConnectorFacade connector, ObjectClass objectClass, Set<Attribute> attrs, OperationOptions options) {
        return new AsyncResult((Object)connector.create(objectClass, attrs, options));
    }

    @Async
    public Future<Uid> update(ConnectorFacade connector, ObjectClass objectClass, Uid uid, Set<Attribute> attrs, OperationOptions options) {
        return new AsyncResult((Object)connector.update(objectClass, uid, attrs, options));
    }

    @Async
    public Future<Uid> delete(ConnectorFacade connector, ObjectClass objectClass, Uid uid, OperationOptions options) {
        connector.delete(objectClass, uid, options);
        return new AsyncResult((Object)uid);
    }

    @Async
    public Future<SyncToken> getLatestSyncToken(ConnectorFacade connector, ObjectClass objectClass) {
        return new AsyncResult((Object)connector.getLatestSyncToken(objectClass));
    }

    @Async
    public Future<ConnectorObject> getObject(ConnectorFacade connector, ObjectClass objectClass, Uid uid, OperationOptions options) {
        return new AsyncResult((Object)connector.getObject(objectClass, uid, options));
    }

    @Async
    public Future<Set<ObjectClassInfo>> getObjectClassInfo(ConnectorFacade connector) {
        Set result = Collections.emptySet();
        try {
            result = connector.schema().getObjectClassInfo();
        }
        catch (Exception e) {
            LOG.debug("While reading schema on connector {}", (Object)connector, (Object)e);
        }
        return new AsyncResult((Object)result);
    }

    @Async
    public Future<String> validate(ConnectorFacade connector) {
        connector.validate();
        return new AsyncResult((Object)"OK");
    }

    @Async
    public Future<String> test(ConnectorFacade connector) {
        connector.test();
        return new AsyncResult((Object)"OK");
    }
}

