/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.patch.GroupPatch;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.PropagationStatus;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.PropagationByResource;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.misc.spring.ApplicationContextProvider;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.provisioning.api.GroupProvisioningManager;
import org.apache.syncope.core.provisioning.api.VirAttrHandler;
import org.apache.syncope.core.provisioning.api.WorkflowResult;
import org.apache.syncope.core.provisioning.api.propagation.PropagationManager;
import org.apache.syncope.core.provisioning.api.propagation.PropagationReporter;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskExecutor;
import org.apache.syncope.core.workflow.api.GroupWorkflowAdapter;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultGroupProvisioningManager
implements GroupProvisioningManager {
    @Autowired
    protected GroupWorkflowAdapter gwfAdapter;
    @Autowired
    protected PropagationManager propagationManager;
    @Autowired
    protected PropagationTaskExecutor taskExecutor;
    @Autowired
    protected GroupDAO groupDAO;
    @Autowired
    protected VirAttrHandler virtAttrHandler;

    public Pair<Long, List<PropagationStatus>> create(GroupTO group, boolean nullPriorityAsync) {
        return this.create(group, Collections.emptySet(), nullPriorityAsync);
    }

    public Pair<Long, List<PropagationStatus>> create(GroupTO groupTO, Set<String> excludedResources, boolean nullPriorityAsync) {
        WorkflowResult created = this.gwfAdapter.create(groupTO);
        List tasks = this.propagationManager.getCreateTasks(AnyTypeKind.GROUP, (Long)created.getResult(), created.getPropByRes(), (Collection)groupTO.getVirAttrs(), excludedResources);
        PropagationReporter propagationReporter = (PropagationReporter)ApplicationContextProvider.getBeanFactory().getBean(PropagationReporter.class);
        this.taskExecutor.execute((Collection)tasks, propagationReporter, nullPriorityAsync);
        return new ImmutablePair(created.getResult(), (Object)propagationReporter.getStatuses());
    }

    public Pair<Long, List<PropagationStatus>> create(GroupTO groupTO, Map<Long, String> groupOwnerMap, Set<String> excludedResources, boolean nullPriorityAsync) {
        WorkflowResult created = this.gwfAdapter.create(groupTO);
        AttrTO groupOwner = (AttrTO)groupTO.getPlainAttrMap().get("");
        if (groupOwner != null) {
            groupOwnerMap.put((Long)created.getResult(), (String)groupOwner.getValues().iterator().next());
        }
        List tasks = this.propagationManager.getCreateTasks(AnyTypeKind.GROUP, (Long)created.getResult(), created.getPropByRes(), (Collection)groupTO.getVirAttrs(), excludedResources);
        PropagationReporter propagationReporter = (PropagationReporter)ApplicationContextProvider.getBeanFactory().getBean(PropagationReporter.class);
        this.taskExecutor.execute((Collection)tasks, propagationReporter, nullPriorityAsync);
        return new ImmutablePair(created.getResult(), null);
    }

    public Pair<Long, List<PropagationStatus>> update(GroupPatch groupPatch, boolean nullPriorityAsync) {
        return this.update(groupPatch, Collections.emptySet(), nullPriorityAsync);
    }

    public Pair<Long, List<PropagationStatus>> update(GroupPatch groupPatch, Set<String> excludedResources, boolean nullPriorityAsync) {
        WorkflowResult updated = this.gwfAdapter.update(groupPatch);
        List tasks = this.propagationManager.getUpdateTasks(AnyTypeKind.GROUP, (Long)updated.getResult(), false, null, updated.getPropByRes(), (Collection)groupPatch.getVirAttrs(), excludedResources);
        PropagationReporter propagationReporter = (PropagationReporter)ApplicationContextProvider.getBeanFactory().getBean(PropagationReporter.class);
        this.taskExecutor.execute((Collection)tasks, propagationReporter, nullPriorityAsync);
        return new ImmutablePair(updated.getResult(), (Object)propagationReporter.getStatuses());
    }

    public List<PropagationStatus> delete(Long key, boolean nullPriorityAsync) {
        return this.delete(key, Collections.emptySet(), nullPriorityAsync);
    }

    public List<PropagationStatus> delete(Long key, Set<String> excludedResources, boolean nullPriorityAsync) {
        ArrayList tasks = new ArrayList();
        for (Map.Entry entry : this.groupDAO.findUsersWithTransitiveResources(key).entrySet()) {
            tasks.addAll(this.propagationManager.getDeleteTasks(AnyTypeKind.USER, (Long)entry.getKey(), (PropagationByResource)entry.getValue(), excludedResources));
        }
        for (Map.Entry entry : this.groupDAO.findAnyObjectsWithTransitiveResources(key).entrySet()) {
            tasks.addAll(this.propagationManager.getDeleteTasks(AnyTypeKind.ANY_OBJECT, (Long)entry.getKey(), (PropagationByResource)entry.getValue(), excludedResources));
        }
        tasks.addAll(this.propagationManager.getDeleteTasks(AnyTypeKind.GROUP, key, null, null));
        PropagationReporter propagationReporter = (PropagationReporter)ApplicationContextProvider.getBeanFactory().getBean(PropagationReporter.class);
        this.taskExecutor.execute(tasks, propagationReporter, nullPriorityAsync);
        this.gwfAdapter.delete(key);
        return propagationReporter.getStatuses();
    }

    public Long unlink(GroupPatch groupPatch) {
        WorkflowResult updated = this.gwfAdapter.update(groupPatch);
        return (Long)updated.getResult();
    }

    public List<PropagationStatus> provision(Long key, Collection<String> resources, boolean nullPriorityAsync) {
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.addAll(ResourceOperation.UPDATE, resources);
        List tasks = this.propagationManager.getUpdateTasks(AnyTypeKind.GROUP, key, false, null, propByRes, null, null);
        PropagationReporter propagationReporter = (PropagationReporter)ApplicationContextProvider.getBeanFactory().getBean(PropagationReporter.class);
        this.taskExecutor.execute((Collection)tasks, propagationReporter, nullPriorityAsync);
        return propagationReporter.getStatuses();
    }

    public List<PropagationStatus> deprovision(Long key, Collection<String> resources, boolean nullPriorityAsync) {
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.addAll(ResourceOperation.DELETE, resources);
        List tasks = this.propagationManager.getDeleteTasks(AnyTypeKind.GROUP, key, propByRes, CollectionUtils.removeAll((Collection)((Group)this.groupDAO.authFind(key)).getResourceNames(), resources));
        PropagationReporter propagationReporter = (PropagationReporter)ApplicationContextProvider.getBeanFactory().getBean(PropagationReporter.class);
        this.taskExecutor.execute((Collection)tasks, propagationReporter, nullPriorityAsync);
        return propagationReporter.getStatuses();
    }

    public Long link(GroupPatch groupPatch) {
        return (Long)this.gwfAdapter.update(groupPatch).getResult();
    }
}

