/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.cache;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.syncope.core.provisioning.api.cache.VirAttrCache;
import org.apache.syncope.core.provisioning.api.cache.VirAttrCacheKey;
import org.apache.syncope.core.provisioning.api.cache.VirAttrCacheValue;

public class MemoryVirAttrCache
implements VirAttrCache {
    protected int ttl;
    protected int maxCacheSize;
    protected final Map<VirAttrCacheKey, VirAttrCacheValue> cache = new HashMap<VirAttrCacheKey, VirAttrCacheValue>();

    public MemoryVirAttrCache(int ttl, int maxCacheSize) {
        this.ttl = ttl;
        this.maxCacheSize = maxCacheSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String type, Long key, String schemaName, VirAttrCacheValue value) {
        Map<VirAttrCacheKey, VirAttrCacheValue> map = this.cache;
        synchronized (map) {
            if (this.cache.size() >= this.maxCacheSize) {
                this.free();
            }
            this.cache.put(new VirAttrCacheKey(type, key, schemaName), value);
        }
    }

    public VirAttrCacheValue get(String type, Long key, String schemaName) {
        return this.cache.get(new VirAttrCacheKey(type, key, schemaName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire(String type, Long key, String schemaName) {
        VirAttrCacheValue value = this.cache.get(new VirAttrCacheKey(type, key, schemaName));
        if (this.isValidEntry(value)) {
            Map<VirAttrCacheKey, VirAttrCacheValue> map = this.cache;
            synchronized (map) {
                value.forceExpiring();
            }
        }
    }

    private void free() {
        HashSet<VirAttrCacheKey> toBeRemoved = new HashSet<VirAttrCacheKey>();
        Map.Entry<VirAttrCacheKey, VirAttrCacheValue> latest = null;
        for (Map.Entry<VirAttrCacheKey, VirAttrCacheValue> entry : this.cache.entrySet()) {
            if (this.isValidEntry(entry.getValue())) {
                Date date = entry.getValue().getLastAccessDate();
                if (latest != null && !((VirAttrCacheValue)latest.getValue()).getLastAccessDate().after(date)) continue;
                latest = entry;
                continue;
            }
            toBeRemoved.add(entry.getKey());
        }
        if (toBeRemoved.isEmpty() && latest != null) {
            this.cache.remove(latest.getKey());
        } else {
            this.cache.keySet().removeAll(toBeRemoved);
        }
    }

    public boolean isValidEntry(VirAttrCacheValue value) {
        Date expiringDate = new Date(value == null ? 0L : value.getCreationDate().getTime() + (long)(this.ttl * 1000));
        return expiringDate.after(new Date());
    }
}

