/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AnyTypeTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.persistence.api.dao.AnyTypeClassDAO;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.provisioning.api.data.AnyTypeDataBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnyTypeDataBinderImpl
implements AnyTypeDataBinder {
    private static final Logger LOG = LoggerFactory.getLogger(AnyTypeDataBinder.class);
    @Autowired
    private AnyTypeClassDAO anyTypeClassDAO;
    @Autowired
    private EntityFactory entityFactory;

    public AnyType create(AnyTypeTO anyTypeTO) {
        AnyType anyType = (AnyType)this.entityFactory.newEntity(AnyType.class);
        this.update(anyType, anyTypeTO);
        return anyType;
    }

    public void update(AnyType anyType, AnyTypeTO anyTypeTO) {
        if (anyType.getKey() == null) {
            anyType.setKey(anyTypeTO.getKey());
        }
        if (anyType.getKind() == null) {
            anyType.setKind(anyTypeTO.getKind());
        }
        if (anyType.getKind() != anyTypeTO.getKind()) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidAnyType);
            sce.getElements().add("AnyTypeKind cannot be changed");
            throw sce;
        }
        anyType.getClasses().clear();
        for (String anyTypeClassName : anyTypeTO.getClasses()) {
            AnyTypeClass anyTypeClass = this.anyTypeClassDAO.find(anyTypeClassName);
            if (anyTypeClass == null) {
                LOG.debug("Invalid " + AnyTypeClass.class.getSimpleName() + "{}, ignoring...", (Object)anyTypeClassName);
                continue;
            }
            anyType.add(anyTypeClass);
        }
    }

    public AnyTypeTO getAnyTypeTO(AnyType anyType) {
        AnyTypeTO anyTypeTO = new AnyTypeTO();
        anyTypeTO.setKey((String)anyType.getKey());
        anyTypeTO.setKind(anyType.getKind());
        for (AnyTypeClass anyTypeClass : anyType.getClasses()) {
            anyTypeTO.getClasses().add(anyTypeClass.getKey());
        }
        return anyTypeTO;
    }
}

