/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ConnInstanceTO;
import org.apache.syncope.common.lib.to.ConnPoolConfTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.ConnConfPropSchema;
import org.apache.syncope.common.lib.types.ConnConfProperty;
import org.apache.syncope.core.misc.spring.BeanUtils;
import org.apache.syncope.core.persistence.api.dao.ConnInstanceDAO;
import org.apache.syncope.core.persistence.api.entity.ConnInstance;
import org.apache.syncope.core.persistence.api.entity.ConnPoolConf;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.provisioning.api.ConnIdBundleManager;
import org.apache.syncope.core.provisioning.api.ConnPoolConfUtils;
import org.apache.syncope.core.provisioning.api.data.ConnInstanceDataBinder;
import org.identityconnectors.framework.api.ConfigurationProperties;
import org.identityconnectors.framework.api.ConfigurationProperty;
import org.identityconnectors.framework.impl.api.ConfigurationPropertyImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConnInstanceDataBinderImpl
implements ConnInstanceDataBinder {
    private static final String[] IGNORE_PROPERTIES = new String[]{"key", "poolConf"};
    @Autowired
    private ConnIdBundleManager connIdBundleManager;
    @Autowired
    private ConnInstanceDAO connInstanceDAO;
    @Autowired
    private EntityFactory entityFactory;

    public ConnInstance getConnInstance(ConnInstanceTO connInstanceTO) {
        SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
        if (connInstanceTO.getLocation() == null) {
            sce.getElements().add("location");
        }
        if (connInstanceTO.getBundleName() == null) {
            sce.getElements().add("bundlename");
        }
        if (connInstanceTO.getVersion() == null) {
            sce.getElements().add("bundleversion");
        }
        if (connInstanceTO.getConnectorName() == null) {
            sce.getElements().add("connectorname");
        }
        if (connInstanceTO.getConf().isEmpty()) {
            sce.getElements().add("configuration");
        }
        ConnInstance connInstance = (ConnInstance)this.entityFactory.newEntity(ConnInstance.class);
        BeanUtils.copyProperties((Object)connInstanceTO, (Object)connInstance, (String[])IGNORE_PROPERTIES);
        if (connInstanceTO.getLocation() != null) {
            connInstance.setLocation(connInstanceTO.getLocation());
        }
        if (connInstanceTO.getPoolConf() != null) {
            connInstance.setPoolConf(ConnPoolConfUtils.getConnPoolConf((ConnPoolConfTO)connInstanceTO.getPoolConf(), (ConnPoolConf)this.entityFactory.newConnPoolConf()));
        }
        if (!sce.isEmpty()) {
            throw sce;
        }
        return connInstance;
    }

    public ConnInstance update(long connInstanceId, ConnInstanceTO connInstanceTO) {
        SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
        if (connInstanceId == 0L) {
            sce.getElements().add("connector id");
        }
        ConnInstance connInstance = this.connInstanceDAO.find(Long.valueOf(connInstanceId));
        connInstance.getCapabilities().clear();
        connInstance.getCapabilities().addAll(connInstanceTO.getCapabilities());
        if (connInstanceTO.getLocation() != null) {
            connInstance.setLocation(connInstanceTO.getLocation());
        }
        if (connInstanceTO.getBundleName() != null) {
            connInstance.setBundleName(connInstanceTO.getBundleName());
        }
        if (connInstanceTO.getVersion() != null) {
            connInstance.setVersion(connInstanceTO.getVersion());
        }
        if (connInstanceTO.getConnectorName() != null) {
            connInstance.setConnectorName(connInstanceTO.getConnectorName());
        }
        if (connInstanceTO.getConf() != null && !connInstanceTO.getConf().isEmpty()) {
            connInstance.setConf(connInstanceTO.getConf());
        }
        if (connInstanceTO.getDisplayName() != null) {
            connInstance.setDisplayName(connInstanceTO.getDisplayName());
        }
        if (connInstanceTO.getConnRequestTimeout() != null) {
            connInstance.setConnRequestTimeout(connInstanceTO.getConnRequestTimeout());
        }
        if (connInstanceTO.getPoolConf() == null) {
            connInstance.setPoolConf(null);
        } else {
            connInstance.setPoolConf(ConnPoolConfUtils.getConnPoolConf((ConnPoolConfTO)connInstanceTO.getPoolConf(), (ConnPoolConf)this.entityFactory.newConnPoolConf()));
        }
        if (!sce.isEmpty()) {
            throw sce;
        }
        return connInstance;
    }

    public ConnConfPropSchema build(ConfigurationProperty property) {
        ConnConfPropSchema connConfPropSchema = new ConnConfPropSchema();
        connConfPropSchema.setName(property.getName());
        connConfPropSchema.setDisplayName(property.getDisplayName(property.getName()));
        connConfPropSchema.setHelpMessage(property.getHelpMessage(property.getName()));
        connConfPropSchema.setRequired(property.isRequired());
        connConfPropSchema.setType(property.getType().getName());
        connConfPropSchema.setOrder(((ConfigurationPropertyImpl)property).getOrder());
        connConfPropSchema.setConfidential(property.isConfidential());
        if (property.getValue() != null) {
            if (property.getValue().getClass().isArray()) {
                connConfPropSchema.getDefaultValues().addAll(Arrays.asList((Object[])property.getValue()));
            } else if (property.getValue() instanceof Collection) {
                connConfPropSchema.getDefaultValues().addAll((Collection)property.getValue());
            } else {
                connConfPropSchema.getDefaultValues().add(property.getValue());
            }
        }
        return connConfPropSchema;
    }

    public ConnInstanceTO getConnInstanceTO(ConnInstance connInstance) {
        ConnInstanceTO connInstanceTO = new ConnInstanceTO();
        connInstanceTO.setKey(connInstance.getKey() == null ? 0L : (Long)connInstance.getKey());
        BeanUtils.copyProperties((Object)connInstance, (Object)connInstanceTO, (String[])IGNORE_PROPERTIES);
        ConfigurationProperties properties = this.connIdBundleManager.getConfigurationProperties(this.connIdBundleManager.getConnectorInfo(connInstance));
        for (final String propName : properties.getPropertyNames()) {
            ConnConfPropSchema schema = this.build(properties.getProperty(propName));
            ConnConfProperty property = (ConnConfProperty)IterableUtils.find((Iterable)connInstanceTO.getConf(), (Predicate)new Predicate<ConnConfProperty>(){

                public boolean evaluate(ConnConfProperty candidate) {
                    return propName.equals(candidate.getSchema().getName());
                }
            });
            if (property == null) {
                property = new ConnConfProperty();
                connInstanceTO.getConf().add(property);
            }
            property.setSchema(schema);
        }
        if (connInstance.getPoolConf() != null) {
            ConnPoolConfTO poolConf = new ConnPoolConfTO();
            BeanUtils.copyProperties((Object)connInstance.getPoolConf(), (Object)poolConf);
            connInstanceTO.setPoolConf(poolConf);
        }
        return connInstanceTO;
    }
}

