/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.SyncopeClientCompositeException;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.patch.GroupPatch;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.TypeExtensionTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.PropagationByResource;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.misc.search.SearchCondConverter;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.DynGroupMembership;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.anyobject.ADynGroupMembership;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.group.TypeExtension;
import org.apache.syncope.core.persistence.api.entity.user.UDynGroupMembership;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.data.GroupDataBinder;
import org.apache.syncope.core.provisioning.java.data.AbstractAnyDataBinder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(rollbackFor={Throwable.class})
public class GroupDataBinderImpl
extends AbstractAnyDataBinder
implements GroupDataBinder {
    @Autowired
    private AnyTypeDAO anyTypeDAO;

    private void setDynMembership(Group group, AnyType anyType, String dynMembershipFIQL) {
        DynGroupMembership dynMembership;
        SearchCond dynMembershipCond = SearchCondConverter.convert((String)dynMembershipFIQL, (String[])new String[0]);
        if (!dynMembershipCond.isValid()) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidSearchExpression);
            sce.getElements().add(dynMembershipFIQL);
            throw sce;
        }
        if (anyType.getKind() == AnyTypeKind.ANY_OBJECT && group.getADynMembership(anyType) == null) {
            dynMembership = (DynGroupMembership)this.entityFactory.newEntity(ADynGroupMembership.class);
            dynMembership.setGroup(group);
            group.add((ADynGroupMembership)dynMembership);
            ((ADynGroupMembership)dynMembership).setAnyType(anyType);
        } else if (anyType.getKind() == AnyTypeKind.USER && group.getUDynMembership() == null) {
            dynMembership = (DynGroupMembership)this.entityFactory.newEntity(UDynGroupMembership.class);
            dynMembership.setGroup(group);
            group.setUDynMembership((UDynGroupMembership)dynMembership);
        } else {
            dynMembership = anyType.getKind() == AnyTypeKind.ANY_OBJECT ? group.getADynMembership(anyType) : group.getUDynMembership();
        }
        dynMembership.setFIQLCond(dynMembershipFIQL);
    }

    public void create(Group group, GroupTO groupTO) {
        AnyType anyType;
        User owner;
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        SyncopeClientException invalidGroups = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidGroup);
        if (groupTO.getName() == null) {
            LOG.error("No name specified for this group");
            invalidGroups.getElements().add("No name specified for this group");
        } else {
            group.setName(groupTO.getName());
        }
        Realm realm = this.realmDAO.find(groupTO.getRealm());
        if (realm == null) {
            SyncopeClientException noRealm = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRealm);
            noRealm.getElements().add("Invalid or null realm specified: " + groupTO.getRealm());
            scce.addException(noRealm);
        }
        group.setRealm(realm);
        this.fill((Any)group, (AnyTO)groupTO, this.anyUtilsFactory.getInstance(AnyTypeKind.GROUP), scce);
        if (groupTO.getUserOwner() != null) {
            owner = (User)this.userDAO.find(groupTO.getUserOwner());
            if (owner == null) {
                LOG.warn("Ignoring invalid user specified as owner: {}", (Object)groupTO.getUserOwner());
            } else {
                group.setUserOwner(owner);
            }
        }
        if (groupTO.getGroupOwner() != null) {
            owner = (Group)this.groupDAO.find(groupTO.getGroupOwner());
            if (owner == null) {
                LOG.warn("Ignoring invalid group specified as owner: {}", (Object)groupTO.getGroupOwner());
            } else {
                group.setGroupOwner((Group)owner);
            }
        }
        if (groupTO.getUDynMembershipCond() != null) {
            this.setDynMembership(group, this.anyTypeDAO.findUser(), groupTO.getUDynMembershipCond());
        }
        for (Map.Entry entry : groupTO.getADynMembershipConds().entrySet()) {
            anyType = this.anyTypeDAO.find((String)entry.getKey());
            if (anyType == null) {
                LOG.warn("Ignoring invalid {}: {}", (Object)AnyType.class.getSimpleName(), entry.getKey());
                continue;
            }
            this.setDynMembership(group, anyType, (String)entry.getValue());
        }
        for (TypeExtensionTO typeExtTO : groupTO.getTypeExtensions()) {
            anyType = this.anyTypeDAO.find(typeExtTO.getAnyType());
            if (anyType == null) {
                LOG.warn("Ignoring invalid {}: {}", (Object)AnyType.class.getSimpleName(), (Object)typeExtTO.getAnyType());
                continue;
            }
            TypeExtension typeExt = (TypeExtension)this.entityFactory.newEntity(TypeExtension.class);
            typeExt.setAnyType(anyType);
            typeExt.setGroup(group);
            group.add(typeExt);
            for (String name : typeExtTO.getAuxClasses()) {
                AnyTypeClass anyTypeClass = this.anyTypeClassDAO.find(name);
                if (anyTypeClass == null) {
                    LOG.warn("Ignoring invalid {}: {}", (Object)AnyTypeClass.class.getSimpleName(), (Object)name);
                    continue;
                }
                typeExt.add(anyTypeClass);
            }
            if (!typeExt.getAuxClasses().isEmpty()) continue;
            group.remove(typeExt);
            typeExt.setGroup(null);
        }
        if (scce.hasExceptions()) {
            throw scce;
        }
    }

    public PropagationByResource update(Group toBeUpdated, GroupPatch groupPatch) {
        AnyType anyType;
        Group group = (Group)this.groupDAO.save((Any)toBeUpdated);
        PropagationByResource propByRes = new PropagationByResource();
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        Map<String, String> oldConnObjectKeys = this.getConnObjectKeys((Any<?>)group);
        this.setRealm((Any<?>)group, (AnyPatch)groupPatch);
        if (groupPatch.getName() != null && StringUtils.isNotBlank((CharSequence)((CharSequence)groupPatch.getName().getValue()))) {
            propByRes.addAll(ResourceOperation.UPDATE, (Collection)group.getResourceNames());
            group.setName((String)groupPatch.getName().getValue());
        }
        if (groupPatch.getUserOwner() != null) {
            group.setUserOwner(groupPatch.getUserOwner().getValue() == null ? null : (User)this.userDAO.find((Long)groupPatch.getUserOwner().getValue()));
        }
        if (groupPatch.getGroupOwner() != null) {
            group.setGroupOwner(groupPatch.getGroupOwner().getValue() == null ? null : (Group)this.groupDAO.find((Long)groupPatch.getGroupOwner().getValue()));
        }
        propByRes.merge(this.fill((Any<?>)group, (AnyPatch)groupPatch, this.anyUtilsFactory.getInstance(AnyTypeKind.GROUP), scce));
        Map<String, String> newConnObjectKeys = this.getConnObjectKeys((Any<?>)group);
        for (Map.Entry<String, String> entry : oldConnObjectKeys.entrySet()) {
            if (!newConnObjectKeys.containsKey(entry.getKey()) || entry.getValue().equals(newConnObjectKeys.get(entry.getKey()))) continue;
            propByRes.addOldConnObjectKey(entry.getKey(), entry.getValue());
            propByRes.add(ResourceOperation.UPDATE, entry.getKey());
        }
        if (groupPatch.getUDynMembershipCond() == null) {
            if (group.getUDynMembership() != null) {
                group.getUDynMembership().setGroup(null);
                group.setUDynMembership(null);
            }
        } else {
            this.setDynMembership(group, this.anyTypeDAO.findUser(), groupPatch.getUDynMembershipCond());
        }
        Iterator<Object> itor = group.getADynMemberships().iterator();
        while (itor.hasNext()) {
            ADynGroupMembership aDynGroupMembership = (ADynGroupMembership)itor.next();
            aDynGroupMembership.setGroup(null);
            itor.remove();
        }
        for (Map.Entry entry : groupPatch.getADynMembershipConds().entrySet()) {
            anyType = this.anyTypeDAO.find((String)entry.getKey());
            if (anyType == null) {
                LOG.warn("Ignoring invalid {}: {}", (Object)AnyType.class.getSimpleName(), entry.getKey());
                continue;
            }
            this.setDynMembership(group, anyType, (String)entry.getValue());
        }
        for (TypeExtensionTO typeExtensionTO : groupPatch.getTypeExtensions()) {
            anyType = this.anyTypeDAO.find(typeExtensionTO.getAnyType());
            if (anyType == null) {
                LOG.warn("Ignoring invalid {}: {}", (Object)AnyType.class.getSimpleName(), (Object)typeExtensionTO.getAnyType());
                continue;
            }
            TypeExtension typeExt = group.getTypeExtension(anyType);
            if (typeExt == null) {
                typeExt = (TypeExtension)this.entityFactory.newEntity(TypeExtension.class);
                typeExt.setAnyType(anyType);
                typeExt.setGroup(group);
                group.add(typeExt);
            }
            for (String name : typeExtensionTO.getAuxClasses()) {
                AnyTypeClass anyTypeClass = this.anyTypeClassDAO.find(name);
                if (anyTypeClass == null) {
                    LOG.warn("Ignoring invalid {}: {}", (Object)AnyTypeClass.class.getSimpleName(), (Object)name);
                    continue;
                }
                typeExt.add(anyTypeClass);
            }
            Iterator itor2 = typeExt.getAuxClasses().iterator();
            while (itor2.hasNext()) {
                AnyTypeClass anyTypeClass = (AnyTypeClass)itor2.next();
                if (typeExtensionTO.getAuxClasses().contains(anyTypeClass.getKey())) continue;
                itor2.remove();
            }
            if (!typeExt.getAuxClasses().isEmpty()) continue;
            group.remove(typeExt);
            typeExt.setGroup(null);
        }
        itor = group.getTypeExtensions().iterator();
        while (itor.hasNext()) {
            TypeExtension typeExtension = (TypeExtension)itor.next();
            if (groupPatch.getTypeExtension((String)typeExtension.getAnyType().getKey()) != null) continue;
            itor.remove();
        }
        if (scce.hasExceptions()) {
            throw scce;
        }
        return propByRes;
    }

    @Transactional(readOnly=true)
    public GroupTO getGroupTO(Group group, boolean details) {
        GroupTO groupTO = new GroupTO();
        groupTO.setCreator(group.getCreator());
        groupTO.setCreationDate(group.getCreationDate());
        groupTO.setLastModifier(group.getLastModifier());
        groupTO.setLastChangeDate(group.getLastChangeDate());
        groupTO.setKey(((Long)group.getKey()).longValue());
        groupTO.setName(group.getName());
        if (group.getUserOwner() != null) {
            groupTO.setUserOwner((Long)group.getUserOwner().getKey());
        }
        if (group.getGroupOwner() != null) {
            groupTO.setGroupOwner((Long)group.getGroupOwner().getKey());
        }
        Map derAttrValues = this.derAttrHandler.getValues((Any)group);
        Map virAttrValues = details ? this.virAttrHander.getValues((Any)group) : Collections.emptyMap();
        this.fillTO((AnyTO)groupTO, group.getRealm().getFullPath(), group.getAuxClasses(), group.getPlainAttrs(), derAttrValues, virAttrValues, group.getResources());
        if (group.getUDynMembership() != null) {
            groupTO.setUDynMembershipCond(group.getUDynMembership().getFIQLCond());
        }
        for (ADynGroupMembership memb : group.getADynMemberships()) {
            groupTO.getADynMembershipConds().put(memb.getAnyType().getKey(), memb.getFIQLCond());
        }
        for (TypeExtension typeExt : group.getTypeExtensions()) {
            TypeExtensionTO typeExtTO = new TypeExtensionTO();
            typeExtTO.setAnyType((String)typeExt.getAnyType().getKey());
            typeExtTO.getAuxClasses().addAll(CollectionUtils.collect((Iterable)typeExt.getAuxClasses(), (Transformer)new Transformer<AnyTypeClass, String>(){

                public String transform(AnyTypeClass clazz) {
                    return (String)clazz.getKey();
                }
            }));
            groupTO.getTypeExtensions().add(typeExtTO);
        }
        return groupTO;
    }

    @Transactional(readOnly=true)
    public GroupTO getGroupTO(Long key) {
        return this.getGroupTO((Group)this.groupDAO.authFind(key), true);
    }
}

