/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.propagation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.syncope.common.lib.to.PropagationStatus;
import org.apache.syncope.common.lib.types.PropagationTaskExecStatus;
import org.apache.syncope.core.misc.utils.ConnObjectUtils;
import org.apache.syncope.core.persistence.api.entity.task.PropagationTask;
import org.apache.syncope.core.provisioning.api.propagation.PropagationReporter;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultPropagationReporter
implements PropagationReporter {
    protected static final Logger LOG = LoggerFactory.getLogger(DefaultPropagationReporter.class);
    @Autowired
    protected ConnObjectUtils connObjectUtils;
    protected final List<PropagationStatus> statuses = new ArrayList<PropagationStatus>();

    protected boolean add(final PropagationStatus status) {
        return IterableUtils.matchesAny(this.statuses, (Predicate)new Predicate<PropagationStatus>(){

            public boolean evaluate(PropagationStatus item) {
                return item.getResource().equals(status.getResource());
            }
        }) ? false : this.statuses.add(status);
    }

    public void onSuccessOrNonPriorityResourceFailures(PropagationTask propagationTask, PropagationTaskExecStatus executionStatus, String failureReason, ConnectorObject beforeObj, ConnectorObject afterObj) {
        PropagationStatus status = new PropagationStatus();
        status.setResource((String)propagationTask.getResource().getKey());
        status.setStatus(executionStatus);
        status.setFailureReason(failureReason);
        if (beforeObj != null) {
            status.setBeforeObj(this.connObjectUtils.getConnObjectTO(beforeObj));
        }
        if (afterObj != null) {
            status.setAfterObj(this.connObjectUtils.getConnObjectTO(afterObj));
        }
        this.add(status);
    }

    public void onPriorityResourceFailure(final String failingResource, Collection<PropagationTask> tasks) {
        LOG.debug("Propagation error: {} priority resource failed to propagate", (Object)failingResource);
        PropagationTask propagationTask = (PropagationTask)IterableUtils.find(tasks, (Predicate)new Predicate<PropagationTask>(){

            public boolean evaluate(PropagationTask task) {
                return ((String)task.getResource().getKey()).equals(failingResource);
            }
        });
        if (propagationTask == null) {
            LOG.error("Could not find {} for {}", (Object)PropagationTask.class.getName(), (Object)failingResource);
        } else {
            PropagationStatus status = new PropagationStatus();
            status.setResource((String)propagationTask.getResource().getKey());
            status.setStatus(PropagationTaskExecStatus.FAILURE);
            status.setFailureReason("Propagation error: " + failingResource + " priority resource failed to propagate.");
            this.add(status);
        }
    }

    public List<PropagationStatus> getStatuses() {
        return Collections.unmodifiableList(this.statuses);
    }
}

