/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.sync;

import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Resource;
import org.apache.syncope.common.lib.types.TraceLevel;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.PolicyDAO;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.resource.Mapping;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.api.entity.task.ProvisioningTask;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.ConnectorFactory;
import org.apache.syncope.core.provisioning.api.sync.ProvisioningReport;
import org.apache.syncope.core.provisioning.java.job.AbstractSchedTaskJobDelegate;
import org.apache.syncope.core.provisioning.java.job.TaskJob;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractProvisioningJobDelegate<T extends ProvisioningTask>
extends AbstractSchedTaskJobDelegate {
    @Resource(name="adminUser")
    protected String adminUser;
    @Autowired
    protected ConnectorFactory connFactory;
    @Autowired
    protected AnyTypeDAO anyTypeDAO;
    @Autowired
    protected ExternalResourceDAO resourceDAO;
    @Autowired
    protected PolicyDAO policyDAO;

    protected String createReport(Collection<ProvisioningReport> provResults, TraceLevel syncTraceLevel, boolean dryRun) {
        if (syncTraceLevel == TraceLevel.NONE) {
            return null;
        }
        StringBuilder report = new StringBuilder();
        if (dryRun) {
            report.append("==>Dry run only, no modifications were made<==\n\n");
        }
        ArrayList<ProvisioningReport> uSuccCreate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> uFailCreate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> uSuccUpdate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> uFailUpdate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> uSuccDelete = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> uFailDelete = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> uSuccNone = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> uIgnore = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> gSuccCreate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> gFailCreate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> gSuccUpdate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> gFailUpdate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> gSuccDelete = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> gFailDelete = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> gSuccNone = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> gIgnore = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> aSuccCreate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> aFailCreate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> aSuccUpdate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> aFailUpdate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> aSuccDelete = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> aFailDelete = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> aSuccNone = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> aIgnore = new ArrayList<ProvisioningReport>();
        for (ProvisioningReport provResult : provResults) {
            AnyType anyType = this.anyTypeDAO.find(provResult.getAnyType());
            block0 : switch (provResult.getStatus()) {
                case SUCCESS: {
                    switch (provResult.getOperation()) {
                        case CREATE: {
                            switch (anyType.getKind()) {
                                case USER: {
                                    uSuccCreate.add(provResult);
                                    break block0;
                                }
                                case GROUP: {
                                    gSuccCreate.add(provResult);
                                    break block0;
                                }
                            }
                            aSuccCreate.add(provResult);
                            break block0;
                        }
                        case UPDATE: {
                            switch (anyType.getKind()) {
                                case USER: {
                                    uSuccUpdate.add(provResult);
                                    break block0;
                                }
                                case GROUP: {
                                    gSuccUpdate.add(provResult);
                                    break block0;
                                }
                            }
                            aSuccUpdate.add(provResult);
                            break block0;
                        }
                        case DELETE: {
                            switch (anyType.getKind()) {
                                case USER: {
                                    uSuccDelete.add(provResult);
                                    break block0;
                                }
                                case GROUP: {
                                    gSuccDelete.add(provResult);
                                    break block0;
                                }
                            }
                            aSuccDelete.add(provResult);
                            break block0;
                        }
                        case NONE: {
                            switch (anyType.getKind()) {
                                case USER: {
                                    uSuccNone.add(provResult);
                                    break block0;
                                }
                                case GROUP: {
                                    gSuccNone.add(provResult);
                                    break block0;
                                }
                            }
                            aSuccNone.add(provResult);
                            break block0;
                        }
                    }
                    break;
                }
                case FAILURE: {
                    switch (provResult.getOperation()) {
                        case CREATE: {
                            switch (anyType.getKind()) {
                                case USER: {
                                    uFailCreate.add(provResult);
                                    break block0;
                                }
                                case GROUP: {
                                    gFailCreate.add(provResult);
                                    break block0;
                                }
                            }
                            aFailCreate.add(provResult);
                            break block0;
                        }
                        case UPDATE: {
                            switch (anyType.getKind()) {
                                case USER: {
                                    uFailUpdate.add(provResult);
                                    break block0;
                                }
                                case GROUP: {
                                    gFailUpdate.add(provResult);
                                    break block0;
                                }
                            }
                            aFailUpdate.add(provResult);
                            break block0;
                        }
                        case DELETE: {
                            switch (anyType.getKind()) {
                                case USER: {
                                    uFailDelete.add(provResult);
                                    break block0;
                                }
                                case GROUP: {
                                    gFailDelete.add(provResult);
                                    break block0;
                                }
                            }
                            aFailDelete.add(provResult);
                            break block0;
                        }
                    }
                    break;
                }
                case IGNORE: {
                    switch (anyType.getKind()) {
                        case USER: {
                            uIgnore.add(provResult);
                            break block0;
                        }
                        case GROUP: {
                            gIgnore.add(provResult);
                            break block0;
                        }
                    }
                    aIgnore.add(provResult);
                    break;
                }
            }
        }
        report.append("Users ").append("[created/failures]: ").append(uSuccCreate.size()).append('/').append(uFailCreate.size()).append(' ').append("[updated/failures]: ").append(uSuccUpdate.size()).append('/').append(uFailUpdate.size()).append(' ').append("[deleted/failures]: ").append(uSuccDelete.size()).append('/').append(uFailDelete.size()).append(' ').append("[no operation/ignored]: ").append(uSuccNone.size()).append('/').append(uIgnore.size()).append('\n');
        report.append("Groups ").append("[created/failures]: ").append(gSuccCreate.size()).append('/').append(gFailCreate.size()).append(' ').append("[updated/failures]: ").append(gSuccUpdate.size()).append('/').append(gFailUpdate.size()).append(' ').append("[deleted/failures]: ").append(gSuccDelete.size()).append('/').append(gFailDelete.size()).append(' ').append("[no operation/ignored]: ").append(gSuccNone.size()).append('/').append(gIgnore.size()).append('\n');
        report.append("Any objects ").append("[created/failures]: ").append(aSuccCreate.size()).append('/').append(aFailCreate.size()).append(' ').append("[updated/failures]: ").append(aSuccUpdate.size()).append('/').append(aFailUpdate.size()).append(' ').append("[deleted/failures]: ").append(aSuccDelete.size()).append('/').append(aFailDelete.size()).append(' ').append("[no operation/ignored]: ").append(aSuccNone.size()).append('/').append(aIgnore.size());
        if (syncTraceLevel == TraceLevel.FAILURES || syncTraceLevel == TraceLevel.ALL) {
            if (!uFailCreate.isEmpty()) {
                report.append("\n\nUsers failed to create: ");
                report.append(ProvisioningReport.produceReport(uFailCreate, (TraceLevel)syncTraceLevel));
            }
            if (!uFailUpdate.isEmpty()) {
                report.append("\nUsers failed to update: ");
                report.append(ProvisioningReport.produceReport(uFailUpdate, (TraceLevel)syncTraceLevel));
            }
            if (!uFailDelete.isEmpty()) {
                report.append("\nUsers failed to delete: ");
                report.append(ProvisioningReport.produceReport(uFailDelete, (TraceLevel)syncTraceLevel));
            }
            if (!gFailCreate.isEmpty()) {
                report.append("\n\nGroups failed to create: ");
                report.append(ProvisioningReport.produceReport(gFailCreate, (TraceLevel)syncTraceLevel));
            }
            if (!gFailUpdate.isEmpty()) {
                report.append("\nGroups failed to update: ");
                report.append(ProvisioningReport.produceReport(gFailUpdate, (TraceLevel)syncTraceLevel));
            }
            if (!gFailDelete.isEmpty()) {
                report.append("\nGroups failed to delete: ");
                report.append(ProvisioningReport.produceReport(gFailDelete, (TraceLevel)syncTraceLevel));
            }
            if (!aFailCreate.isEmpty()) {
                report.append("\nAny objects failed to create: ");
                report.append(ProvisioningReport.produceReport(aFailCreate, (TraceLevel)syncTraceLevel));
            }
            if (!aFailUpdate.isEmpty()) {
                report.append("\nAny objects failed to update: ");
                report.append(ProvisioningReport.produceReport(aFailUpdate, (TraceLevel)syncTraceLevel));
            }
            if (!aFailDelete.isEmpty()) {
                report.append("\nAny objects failed to delete: ");
                report.append(ProvisioningReport.produceReport(aFailDelete, (TraceLevel)syncTraceLevel));
            }
        }
        if (syncTraceLevel == TraceLevel.ALL) {
            report.append("\n\nUsers created:\n").append(ProvisioningReport.produceReport(uSuccCreate, (TraceLevel)syncTraceLevel)).append("\nUsers updated:\n").append(ProvisioningReport.produceReport(uSuccUpdate, (TraceLevel)syncTraceLevel)).append("\nUsers deleted:\n").append(ProvisioningReport.produceReport(uSuccDelete, (TraceLevel)syncTraceLevel)).append("\nUsers no operation:\n").append(ProvisioningReport.produceReport(uSuccNone, (TraceLevel)syncTraceLevel)).append("\nUsers ignored:\n").append(ProvisioningReport.produceReport(uIgnore, (TraceLevel)syncTraceLevel));
            report.append("\n\nGroups created:\n").append(ProvisioningReport.produceReport(gSuccCreate, (TraceLevel)syncTraceLevel)).append("\nGroups updated:\n").append(ProvisioningReport.produceReport(gSuccUpdate, (TraceLevel)syncTraceLevel)).append("\nGroups deleted:\n").append(ProvisioningReport.produceReport(gSuccDelete, (TraceLevel)syncTraceLevel)).append("\nGroups no operation:\n").append(ProvisioningReport.produceReport(gSuccNone, (TraceLevel)syncTraceLevel)).append("\nGroups ignored:\n").append(ProvisioningReport.produceReport(gSuccNone, (TraceLevel)syncTraceLevel));
            report.append("\n\nAny objects created:\n").append(ProvisioningReport.produceReport(aSuccCreate, (TraceLevel)syncTraceLevel)).append("\nAny objects updated:\n").append(ProvisioningReport.produceReport(aSuccUpdate, (TraceLevel)syncTraceLevel)).append("\nAny objects deleted:\n").append(ProvisioningReport.produceReport(aSuccDelete, (TraceLevel)syncTraceLevel)).append("\nAny objects no operation:\n").append(ProvisioningReport.produceReport(aSuccNone, (TraceLevel)syncTraceLevel)).append("\nAny objects ignored:\n").append(ProvisioningReport.produceReport(aSuccNone, (TraceLevel)syncTraceLevel));
        }
        return report.toString();
    }

    @Override
    protected String doExecute(boolean dryRun) throws JobExecutionException {
        try {
            Connector connector;
            Class<T> clazz = this.getTaskClassReference();
            if (!clazz.isAssignableFrom(this.task.getClass())) {
                throw new JobExecutionException("Task " + this.task.getKey() + " isn't a ProvisioningTask");
            }
            ProvisioningTask provisioningTask = (ProvisioningTask)clazz.cast(this.task);
            try {
                connector = this.connFactory.getConnector(provisioningTask.getResource());
            }
            catch (Exception e) {
                String msg = String.format("Connector instance bean for resource %s and connInstance %s not found", provisioningTask.getResource(), provisioningTask.getResource().getConnector());
                throw new JobExecutionException(msg, (Throwable)e);
            }
            boolean noMapping = true;
            for (Provision provision : provisioningTask.getResource().getProvisions()) {
                Mapping mapping = provision.getMapping();
                if (mapping == null) continue;
                noMapping = false;
                if (mapping.getConnObjectKeyItem() != null) continue;
                throw new JobExecutionException("Invalid ConnObjectKey mapping for provision " + provision);
            }
            if (noMapping) {
                return "No mapping configured for both users and groups: aborting...";
            }
            return this.doExecuteProvisioning(provisioningTask, connector, dryRun);
        }
        catch (Throwable t) {
            LOG.error("While executing provisioning job {}", (Object)this.getClass().getName(), (Object)t);
            throw t;
        }
    }

    protected abstract String doExecuteProvisioning(T var1, Connector var2, boolean var3) throws JobExecutionException;

    @Override
    protected boolean hasToBeRegistered(TaskExec execution) {
        ProvisioningTask provTask = (ProvisioningTask)this.task;
        return TaskJob.Status.valueOf(execution.getStatus()) == TaskJob.Status.FAILURE && provTask.getResource().getSyncTraceLevel().ordinal() >= TraceLevel.FAILURES.ordinal() || provTask.getResource().getSyncTraceLevel().ordinal() >= TraceLevel.SUMMARY.ordinal();
    }

    private Class<T> getTaskClassReference() {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }
}

