/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.sync;

import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.patch.PasswordPatch;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.syncope.common.lib.types.ConnConfProperty;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.ConnInstance;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.sync.ProvisioningProfile;
import org.apache.syncope.core.provisioning.api.sync.ProvisioningReport;
import org.apache.syncope.core.provisioning.java.sync.DefaultSyncActions;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class DBPasswordSyncActions
extends DefaultSyncActions {
    private static final Logger LOG = LoggerFactory.getLogger(DBPasswordSyncActions.class);
    private static final String CLEARTEXT = "CLEARTEXT";
    @Autowired
    private UserDAO userDAO;
    private String encodedPassword;
    private CipherAlgorithm cipher;

    @Override
    @Transactional(readOnly=true)
    public <A extends AnyTO> SyncDelta beforeProvision(ProvisioningProfile<?, ?> profile, SyncDelta delta, A any) throws JobExecutionException {
        if (any instanceof UserTO) {
            String password = ((UserTO)any).getPassword();
            this.parseEncodedPassword(password, profile.getConnector());
        }
        return delta;
    }

    @Transactional(readOnly=true)
    public <A extends AnyTO, M extends AnyPatch> SyncDelta beforeUpdate(ProvisioningProfile<?, ?> profile, SyncDelta delta, A any, M anyPatch) throws JobExecutionException {
        if (anyPatch instanceof UserPatch) {
            PasswordPatch modPassword = ((UserPatch)anyPatch).getPassword();
            this.parseEncodedPassword(modPassword == null ? null : (String)modPassword.getValue(), profile.getConnector());
        }
        return delta;
    }

    private void parseEncodedPassword(String password, Connector connector) {
        ConnInstance connInstance;
        String cipherAlgorithm;
        if (password != null && !CLEARTEXT.equals(cipherAlgorithm = this.getCipherAlgorithm(connInstance = connector.getConnInstance()))) {
            try {
                this.encodedPassword = password;
                this.cipher = CipherAlgorithm.valueOf((String)cipherAlgorithm);
            }
            catch (IllegalArgumentException e) {
                LOG.error("Cipher algorithm not allowed: {}", (Object)cipherAlgorithm, (Object)e);
                this.encodedPassword = null;
            }
        }
    }

    private String getCipherAlgorithm(ConnInstance connInstance) {
        ConnConfProperty cipherAlgorithm = (ConnConfProperty)IterableUtils.find((Iterable)connInstance.getConf(), (Predicate)new Predicate<ConnConfProperty>(){

            public boolean evaluate(ConnConfProperty property) {
                return "cipherAlgorithm".equals(property.getSchema().getName()) && property.getValues() != null && !property.getValues().isEmpty();
            }
        });
        return cipherAlgorithm == null ? CLEARTEXT : (String)cipherAlgorithm.getValues().get(0);
    }

    @Override
    @Transactional(readOnly=true)
    public <A extends AnyTO> void after(ProvisioningProfile<?, ?> profile, SyncDelta delta, A any, ProvisioningReport result) throws JobExecutionException {
        if (any instanceof UserTO && this.encodedPassword != null && this.cipher != null) {
            User syncopeUser = (User)this.userDAO.find(Long.valueOf(any.getKey()));
            if (syncopeUser != null) {
                syncopeUser.setEncodedPassword(this.encodedPassword.toUpperCase(), this.cipher);
            }
            this.encodedPassword = null;
            this.cipher = null;
        }
    }
}

