/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.sync;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.patch.AttrPatch;
import org.apache.syncope.common.lib.patch.GroupPatch;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.task.SyncTask;
import org.apache.syncope.core.provisioning.api.ProvisioningManager;
import org.apache.syncope.core.provisioning.api.WorkflowResult;
import org.apache.syncope.core.provisioning.api.sync.GroupSyncResultHandler;
import org.apache.syncope.core.provisioning.api.sync.ProvisioningReport;
import org.apache.syncope.core.provisioning.java.sync.AbstractSyncResultHandler;
import org.identityconnectors.framework.common.objects.SyncDelta;

public class GroupSyncResultHandlerImpl
extends AbstractSyncResultHandler
implements GroupSyncResultHandler {
    protected final Map<Long, String> groupOwnerMap = new HashMap<Long, String>();

    public Map<Long, String> getGroupOwnerMap() {
        return this.groupOwnerMap;
    }

    @Override
    protected AnyUtils getAnyUtils() {
        return this.anyUtilsFactory.getInstance(AnyTypeKind.GROUP);
    }

    @Override
    protected String getName(AnyTO anyTO) {
        return ((GroupTO)GroupTO.class.cast(anyTO)).getName();
    }

    @Override
    protected ProvisioningManager<?, ?> getProvisioningManager() {
        return this.groupProvisioningManager;
    }

    @Override
    protected Any<?> getAny(long key) {
        try {
            return this.groupDAO.authFind(Long.valueOf(key));
        }
        catch (Exception e) {
            LOG.warn("Error retrieving group {}", (Object)key, (Object)e);
            return null;
        }
    }

    @Override
    protected AnyTO getAnyTO(long key) {
        return this.groupDataBinder.getGroupTO(Long.valueOf(key));
    }

    @Override
    protected AnyPatch newPatch(long key) {
        GroupPatch patch = new GroupPatch();
        patch.setKey(key);
        return patch;
    }

    @Override
    protected WorkflowResult<Long> update(AnyPatch patch) {
        return this.gwfAdapter.update((GroupPatch)patch);
    }

    @Override
    protected AnyTO doCreate(AnyTO anyTO, SyncDelta delta, ProvisioningReport result) {
        GroupTO groupTO = (GroupTO)GroupTO.class.cast(anyTO);
        Pair created = this.groupProvisioningManager.create(groupTO, this.groupOwnerMap, Collections.singleton(((SyncTask)this.profile.getTask()).getResource().getKey()), true);
        result.setKey((Long)created.getKey());
        result.setName(this.getName(anyTO));
        return this.getAnyTO((Long)created.getKey());
    }

    @Override
    protected AnyTO doUpdate(AnyTO before, AnyPatch anyPatch, SyncDelta delta, ProvisioningReport result) {
        GroupPatch groupPatch = (GroupPatch)GroupPatch.class.cast(anyPatch);
        Pair updated = this.groupProvisioningManager.update((AnyPatch)groupPatch, true);
        String groupOwner = null;
        for (AttrPatch attrPatch : groupPatch.getPlainAttrs()) {
            if (attrPatch.getOperation() != PatchOperation.ADD_REPLACE || attrPatch.getAttrTO() == null || !attrPatch.getAttrTO().getSchema().isEmpty() || attrPatch.getAttrTO().getValues().isEmpty()) continue;
            groupOwner = (String)attrPatch.getAttrTO().getValues().get(0);
        }
        if (groupOwner != null) {
            this.groupOwnerMap.put((Long)updated.getKey(), groupOwner);
        }
        GroupTO after = this.groupDataBinder.getGroupTO((Long)updated.getKey());
        result.setName(this.getName((AnyTO)after));
        return after;
    }
}

