/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.sync;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.syncope.core.misc.utils.MappingUtils;
import org.apache.syncope.core.persistence.api.dao.search.AnyCond;
import org.apache.syncope.core.persistence.api.dao.search.AttributeCond;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.resource.MappingItem;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.provisioning.api.data.MappingItemTransformer;
import org.apache.syncope.core.provisioning.api.sync.SyncCorrelationRule;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.ConnectorObject;

public class PlainAttrsSyncCorrelationRule
implements SyncCorrelationRule {
    private final List<String> plainSchemaNames;
    private final Provision provision;

    public PlainAttrsSyncCorrelationRule(String[] plainSchemaNames, Provision provision) {
        this.plainSchemaNames = Arrays.asList(plainSchemaNames);
        this.provision = provision;
    }

    public SearchCond getSearchCond(ConnectorObject connObj) {
        HashMap<String, MappingItem> mappingItems = new HashMap<String, MappingItem>();
        for (MappingItem item : MappingUtils.getSyncMappingItems((Provision)this.provision)) {
            mappingItems.put(item.getIntAttrName(), item);
        }
        SearchCond searchCond = null;
        for (String schema : this.plainSchemaNames) {
            SearchCond nodeCond;
            AnyCond cond;
            AttributeCond.Type type;
            Attribute attr;
            Attribute attribute = attr = mappingItems.get(schema) == null ? null : connObj.getAttributeByName(((MappingItem)mappingItems.get(schema)).getExtAttrName());
            if (attr == null) {
                throw new IllegalArgumentException("Connector object does not contains the attributes to perform the search: " + schema);
            }
            List values = attr.getValue();
            for (MappingItemTransformer transformer : MappingUtils.getMappingItemTransformers((MappingItem)((MappingItem)mappingItems.get(schema)))) {
                values = transformer.beforeSync(values);
            }
            String expression = null;
            if (values == null || values.isEmpty() || values.size() == 1 && values.get(0) == null) {
                type = AttributeCond.Type.ISNULL;
            } else {
                type = AttributeCond.Type.EQ;
                String string = expression = values.size() > 1 ? values.toString() : values.get(0).toString();
            }
            if ("key".equalsIgnoreCase(schema) || "username".equalsIgnoreCase(schema) || "name".equalsIgnoreCase(schema)) {
                cond = new AnyCond();
                cond.setSchema(schema);
                cond.setType(type);
                cond.setExpression(expression);
                nodeCond = SearchCond.getLeafCond((AttributeCond)cond);
            } else {
                cond = new AttributeCond();
                cond.setSchema(schema);
                cond.setType(type);
                cond.setExpression(expression);
                nodeCond = SearchCond.getLeafCond((AttributeCond)cond);
            }
            searchCond = searchCond == null ? nodeCond : SearchCond.getAndCond((SearchCond)searchCond, (SearchCond)nodeCond);
        }
        return searchCond;
    }
}

