/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.sync;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.policy.SyncPolicySpec;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.misc.serialization.POJOHelper;
import org.apache.syncope.core.misc.utils.MappingUtils;
import org.apache.syncope.core.persistence.api.attrvalue.validation.ParsingValidationException;
import org.apache.syncope.core.persistence.api.dao.AnyDAO;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.resource.MappingItem;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.api.entity.task.ProvisioningTask;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.data.MappingItemTransformer;
import org.apache.syncope.core.provisioning.api.sync.SyncCorrelationRule;
import org.apache.syncope.core.provisioning.java.sync.PlainAttrsSyncCorrelationRule;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.filter.EqualsFilter;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@Component
public class SyncUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SyncUtils.class);
    @Autowired
    private PlainSchemaDAO plainSchemaDAO;
    @Autowired
    private AnyObjectDAO anyObjectDAO;
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private GroupDAO groupDAO;
    @Autowired
    private AnySearchDAO searchDAO;
    @Autowired
    private AnyUtilsFactory anyUtilsFactory;

    public Long findMatchingAnyKey(AnyType anyType, String name, ExternalResource resource, Connector connector) {
        Provision provision = resource.getProvision(anyType);
        if (provision == null) {
            return null;
        }
        Long result = null;
        AnyUtils anyUtils = this.anyUtilsFactory.getInstance(anyType.getKind());
        final ArrayList found = new ArrayList();
        connector.search(provision.getObjectClass(), (Filter)new EqualsFilter((Attribute)new Name(name)), new ResultsHandler(){

            public boolean handle(ConnectorObject obj) {
                return found.add(obj);
            }
        }, MappingUtils.buildOperationOptions(MappingUtils.getSyncMappingItems((Provision)provision).iterator()));
        if (found.isEmpty()) {
            LOG.debug("No {} found on {} with __NAME__ {}", new Object[]{provision.getObjectClass(), resource, name});
        } else {
            if (found.size() > 1) {
                LOG.warn("More than one {} found on {} with __NAME__ {} - taking first only", new Object[]{provision.getObjectClass(), resource, name});
            }
            ConnectorObject connObj = (ConnectorObject)found.iterator().next();
            try {
                List<Long> anyKeys = this.findExisting(connObj.getUid().getUidValue(), connObj, provision, anyUtils);
                if (anyKeys.isEmpty()) {
                    LOG.debug("No matching {} found for {}, aborting", (Object)anyUtils.getAnyTypeKind(), (Object)connObj);
                } else {
                    if (anyKeys.size() > 1) {
                        LOG.warn("More than one {} found {} - taking first only", (Object)anyUtils.getAnyTypeKind(), anyKeys);
                    }
                    result = anyKeys.iterator().next();
                }
            }
            catch (IllegalArgumentException e) {
                LOG.warn(e.getMessage());
            }
        }
        return result;
    }

    private AnyDAO<?> getAnyDAO(MappingItem connObjectKeyItem) {
        return AnyTypeKind.USER == connObjectKeyItem.getIntMappingType().getAnyTypeKind() ? this.userDAO : (AnyTypeKind.ANY_OBJECT == connObjectKeyItem.getIntMappingType().getAnyTypeKind() ? this.anyObjectDAO : this.groupDAO);
    }

    private List<Long> findByConnObjectKeyItem(String uid, Provision provision, AnyUtils anyUtils) {
        ArrayList<Long> result = new ArrayList<Long>();
        MappingItem connObjectKeyItem = MappingUtils.getConnObjectKeyItem((Provision)provision);
        String transfUid = uid;
        for (MappingItemTransformer transformer : MappingUtils.getMappingItemTransformers((MappingItem)connObjectKeyItem)) {
            List output = transformer.beforeSync(Collections.singletonList(transfUid));
            if (output == null || output.isEmpty()) continue;
            transfUid = output.get(0).toString();
        }
        switch (connObjectKeyItem.getIntMappingType()) {
            case UserPlainSchema: 
            case GroupPlainSchema: 
            case AnyObjectPlainSchema: {
                PlainAttrValue value = anyUtils.newPlainAttrValue();
                PlainSchema schema = (PlainSchema)this.plainSchemaDAO.find(connObjectKeyItem.getIntAttrName());
                if (schema == null) {
                    value.setStringValue(transfUid);
                } else {
                    try {
                        value.parseValue(schema, transfUid);
                    }
                    catch (ParsingValidationException e) {
                        LOG.error("While parsing provided __UID__ {}", (Object)transfUid, (Object)e);
                        value.setStringValue(transfUid);
                    }
                }
                List anys = this.getAnyDAO(connObjectKeyItem).findByAttrValue(connObjectKeyItem.getIntAttrName(), value);
                for (Any any : anys) {
                    result.add((Long)any.getKey());
                }
                break;
            }
            case UserDerivedSchema: 
            case GroupDerivedSchema: 
            case AnyObjectDerivedSchema: {
                List anys = this.getAnyDAO(connObjectKeyItem).findByDerAttrValue(connObjectKeyItem.getIntAttrName(), transfUid);
                for (Any any : anys) {
                    result.add((Long)any.getKey());
                }
                break;
            }
            case UserKey: 
            case GroupKey: 
            case AnyObjectKey: {
                Any any = this.getAnyDAO(connObjectKeyItem).find(Long.valueOf(Long.parseLong(transfUid)));
                if (any == null) break;
                result.add((Long)any.getKey());
                break;
            }
            case Username: {
                User user = this.userDAO.find(transfUid);
                if (user == null) break;
                result.add((Long)user.getKey());
                break;
            }
            case GroupName: {
                Group group = this.groupDAO.find(transfUid);
                if (group == null) break;
                result.add((Long)group.getKey());
                break;
            }
            default: {
                LOG.error("Invalid connObjectKey type '{}'", (Object)connObjectKeyItem.getIntMappingType());
            }
        }
        return result;
    }

    private List<Long> findByCorrelationRule(ConnectorObject connObj, SyncCorrelationRule rule, AnyTypeKind type) {
        ArrayList<Long> result = new ArrayList<Long>();
        for (Any any : this.searchDAO.search(rule.getSearchCond(connObj), type)) {
            result.add((Long)any.getKey());
        }
        return result;
    }

    private SyncCorrelationRule getCorrelationRule(Provision provision, SyncPolicySpec policySpec) {
        SyncCorrelationRule result = null;
        String syncCorrelationRule = (String)policySpec.getCorrelationRules().get(provision.getAnyType().getKey());
        if (StringUtils.isNotBlank((CharSequence)syncCorrelationRule)) {
            if (syncCorrelationRule.charAt(0) == '[') {
                result = new PlainAttrsSyncCorrelationRule((String[])POJOHelper.deserialize((String)syncCorrelationRule, String[].class), provision);
            } else {
                try {
                    result = (SyncCorrelationRule)Class.forName(syncCorrelationRule).newInstance();
                }
                catch (Exception e) {
                    LOG.error("Failure instantiating correlation rule class '{}'", (Object)syncCorrelationRule, (Object)e);
                }
            }
        }
        return result;
    }

    public List<Long> findExisting(String uid, ConnectorObject connObj, Provision provision, AnyUtils anyUtils) {
        SyncPolicySpec syncPolicySpec = null;
        if (provision.getResource().getSyncPolicy() != null) {
            syncPolicySpec = provision.getResource().getSyncPolicy().getSpecification();
        }
        SyncCorrelationRule syncRule = null;
        if (syncPolicySpec != null) {
            syncRule = this.getCorrelationRule(provision, syncPolicySpec);
        }
        return syncRule == null ? this.findByConnObjectKeyItem(uid, provision, anyUtils) : this.findByCorrelationRule(connObj, syncRule, anyUtils.getAnyTypeKind());
    }

    public Boolean readEnabled(ConnectorObject connectorObject, ProvisioningTask task) {
        Attribute status;
        Boolean enabled = null;
        if (task.isSyncStatus() && (status = AttributeUtil.find((String)OperationalAttributes.ENABLE_NAME, (Set)connectorObject.getAttributes())) != null && status.getValue() != null && !status.getValue().isEmpty()) {
            enabled = (Boolean)status.getValue().get(0);
        }
        return enabled;
    }
}

