/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.patch.AnyObjectPatch;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.PropagationStatus;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.PropagationByResource;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.misc.spring.ApplicationContextProvider;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.provisioning.api.AnyObjectProvisioningManager;
import org.apache.syncope.core.provisioning.api.VirAttrHandler;
import org.apache.syncope.core.provisioning.api.WorkflowResult;
import org.apache.syncope.core.provisioning.api.propagation.PropagationManager;
import org.apache.syncope.core.provisioning.api.propagation.PropagationReporter;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskExecutor;
import org.apache.syncope.core.workflow.api.AnyObjectWorkflowAdapter;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultAnyObjectProvisioningManager
implements AnyObjectProvisioningManager {
    @Autowired
    protected AnyObjectWorkflowAdapter awfAdapter;
    @Autowired
    protected PropagationManager propagationManager;
    @Autowired
    protected PropagationTaskExecutor taskExecutor;
    @Autowired
    protected VirAttrHandler virtAttrHandler;
    @Autowired
    protected AnyObjectDAO anyObjectDAO;

    public Pair<Long, List<PropagationStatus>> create(AnyObjectTO anyObjectTO, boolean nullPriorityAsync) {
        return this.create(anyObjectTO, Collections.emptySet(), nullPriorityAsync);
    }

    public Pair<Long, List<PropagationStatus>> create(AnyObjectTO anyObjectTO, Set<String> excludedResources, boolean nullPriorityAsync) {
        WorkflowResult created = this.awfAdapter.create(anyObjectTO);
        List tasks = this.propagationManager.getCreateTasks(AnyTypeKind.ANY_OBJECT, (Long)created.getResult(), created.getPropByRes(), (Collection)anyObjectTO.getVirAttrs(), excludedResources);
        PropagationReporter propagationReporter = (PropagationReporter)ApplicationContextProvider.getBeanFactory().getBean(PropagationReporter.class);
        this.taskExecutor.execute((Collection)tasks, propagationReporter, nullPriorityAsync);
        return new ImmutablePair(created.getResult(), (Object)propagationReporter.getStatuses());
    }

    public Pair<Long, List<PropagationStatus>> update(AnyObjectPatch anyObjectPatch, boolean nullPriorityAsync) {
        return this.update(anyObjectPatch, Collections.emptySet(), nullPriorityAsync);
    }

    public Pair<Long, List<PropagationStatus>> update(AnyObjectPatch anyObjectPatch, Set<String> excludedResources, boolean nullPriorityAsync) {
        WorkflowResult updated = this.awfAdapter.update(anyObjectPatch);
        List tasks = this.propagationManager.getUpdateTasks(AnyTypeKind.ANY_OBJECT, (Long)updated.getResult(), false, null, updated.getPropByRes(), (Collection)anyObjectPatch.getVirAttrs(), excludedResources);
        PropagationReporter propagationReporter = (PropagationReporter)ApplicationContextProvider.getBeanFactory().getBean(PropagationReporter.class);
        this.taskExecutor.execute((Collection)tasks, propagationReporter, nullPriorityAsync);
        return new ImmutablePair(updated.getResult(), (Object)propagationReporter.getStatuses());
    }

    public List<PropagationStatus> delete(Long key, boolean nullPriorityAsync) {
        return this.delete(key, Collections.emptySet(), nullPriorityAsync);
    }

    public List<PropagationStatus> delete(Long key, Set<String> excludedResources, boolean nullPriorityAsync) {
        List tasks = this.propagationManager.getDeleteTasks(AnyTypeKind.ANY_OBJECT, key, null, excludedResources);
        PropagationReporter propagationReporter = (PropagationReporter)ApplicationContextProvider.getBeanFactory().getBean(PropagationReporter.class);
        this.taskExecutor.execute((Collection)tasks, propagationReporter, nullPriorityAsync);
        this.awfAdapter.delete(key);
        return propagationReporter.getStatuses();
    }

    public Long unlink(AnyObjectPatch anyObjectPatch) {
        return (Long)this.awfAdapter.update(anyObjectPatch).getResult();
    }

    public Long link(AnyObjectPatch anyObjectPatch) {
        return (Long)this.awfAdapter.update(anyObjectPatch).getResult();
    }

    public List<PropagationStatus> provision(Long key, Collection<String> resources, boolean nullPriorityAsync) {
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.addAll(ResourceOperation.UPDATE, resources);
        List tasks = this.propagationManager.getUpdateTasks(AnyTypeKind.ANY_OBJECT, key, false, null, propByRes, null, null);
        PropagationReporter propagationReporter = (PropagationReporter)ApplicationContextProvider.getBeanFactory().getBean(PropagationReporter.class);
        this.taskExecutor.execute((Collection)tasks, propagationReporter, nullPriorityAsync);
        return propagationReporter.getStatuses();
    }

    public List<PropagationStatus> deprovision(Long key, Collection<String> resources, boolean nullPriorityAsync) {
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.addAll(ResourceOperation.DELETE, resources);
        List tasks = this.propagationManager.getDeleteTasks(AnyTypeKind.ANY_OBJECT, key, propByRes, CollectionUtils.removeAll((Collection)this.anyObjectDAO.findAllResourceNames((AnyObject)this.anyObjectDAO.authFind(key)), resources));
        PropagationReporter propagationReporter = (PropagationReporter)ApplicationContextProvider.getBeanFactory().getBean(PropagationReporter.class);
        this.taskExecutor.execute((Collection)tasks, propagationReporter, nullPriorityAsync);
        return propagationReporter.getStatuses();
    }
}

