/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.MapContext;
import org.apache.syncope.core.misc.jexl.JexlUtils;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.DerSchema;
import org.apache.syncope.core.provisioning.api.DerAttrHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class DerAttrHandlerImpl
implements DerAttrHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DerAttrHandler.class);
    @Autowired
    private AnyUtilsFactory anyUtilsFactory;

    private Map<DerSchema, String> getValues(Any<?> any, Set<DerSchema> schemas) {
        HashMap<DerSchema, String> result = new HashMap<DerSchema, String>(schemas.size());
        for (DerSchema schema : schemas) {
            MapContext jexlContext = new MapContext();
            JexlUtils.addPlainAttrsToContext((Collection)any.getPlainAttrs(), (JexlContext)jexlContext);
            JexlUtils.addFieldsToContext(any, (JexlContext)jexlContext);
            result.put(schema, JexlUtils.evaluate((String)schema.getExpression(), (JexlContext)jexlContext));
        }
        return result;
    }

    @Transactional(readOnly=true)
    public String getValue(Any<?> any, DerSchema schema) {
        if (!this.anyUtilsFactory.getInstance(any).getAllowedSchemas(any, DerSchema.class).contains(schema)) {
            LOG.debug("{} not allowed for {}", (Object)schema, any);
            return null;
        }
        return this.getValues(any, Collections.singleton(schema)).get(schema);
    }

    @Transactional(readOnly=true)
    public Map<DerSchema, String> getValues(Any<?> any) {
        return this.getValues(any, this.anyUtilsFactory.getInstance(any).getAllowedSchemas(any, DerSchema.class));
    }
}

